#!/bin/bash
set -eu

# Set gmsh version
GMSH_VER="3.0.5"

# Set tarball name
GMSH_TARBALL_NAME="gmsh-${GMSH_VER}-win64-precompiled"

# Clean up from previous installation
rm -f $GMSH_TARBALL_NAME.tar.gz
rm -rf install src

# Download Windows 64-bit precompiled gmsh from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py "http://issm.jpl.nasa.gov/files/externalpackages/${GMSH_TARBALL_NAME}.tar.gz" "${GMSH_TARBALL_NAME}.tar.gz"

# Untar gmsh
tar -xvzf $GMSH_TARBALL_NAME.tar.gz

# Copy gmsh to path expected by packager
mkdir install
cp gmsh.exe install
rm gmsh.exe
