/*\file FieldDepthAverage.c
 *\brief: average field throfieldh thickness
 */

#include "./FieldDepthAverage.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	Vec      field=NULL;
	char*    fieldname=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&FieldDepthAverageUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&field,FIELD);
	FetchData(&fieldname,FIELDNAME);

	/*!Call core code: */
	FieldDepthAveragex(field,elements,nodes,loads,materials,parameters,fieldname);

	/*write output : */
	WriteData(FIELDOUT,field);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&field);
	xfree((void**)&fieldname);
	
	/*end module: */
	MODULEEND();

}

void FieldDepthAverageUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [field] = %s(elements, nodes,loads, materials, parameters,field,fieldname);\n",__FUNCT__);
	_printf_("\n");
}
