/*\file BuildNodeSets.c
 *\brief: build degrees of freedom sets for every node
 */

#include "./BuildNodeSets.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet*     nodes=NULL;

	/* output datasets: */
	NodeSets*    nodesets=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BuildNodeSetsUsage);

	/*Input datasets: */
	FetchData(&nodes,NODES);
	
	/*!Generate internal degree of freedom numbers: */
	BuildNodeSetsx(&nodesets, nodes);

	/*write output datasets: */
	WriteNodeSets(NODESETS,nodesets); 

	/*Free ressources: */
	delete nodes;
	delete nodesets;

	/*end module: */
	MODULEEND();
}

void BuildNodeSetsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [m.nodesets]=%s(m.nodes);\n",__FUNCT__);
	_printf_("\n");
}
