/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

#include "./Object.h"
#include "../toolkits/toolkits.h"

class Element: public Object{

	public: 
		virtual       ~Element(){};
		virtual void  Echo()=0;
		virtual void  DeepEcho()=0;
		virtual int   GetId()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual char* GetName()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual void  Configure(void* loads,void* nodes,void* materials,void* parameters)=0;
		virtual void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type)=0;
		virtual void  UpdateFromInputs(void* inputs)=0;
		virtual void  GetNodes(void** nodes)=0;
		virtual void* GetMatPar()=0;
		virtual int   GetShelf()=0; 
		virtual int   GetOnBed()=0;
		virtual void  GetThicknessList(double* thickness_list)=0;
		virtual void  GetBedList(double* bed_list)=0;
		virtual void  Du(Vec du_g,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void  Gradj(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type,char* control_type)=0;
		virtual void  GradjDrag(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void  GradjB(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual double Misfit(void* inputs,int analysis_type,int sub_analysis_type)=0;
		virtual void  ComputePressure(Vec p_g)=0;
		virtual double MassFlux(double* segment,double* ug)=0;

		int           Enum();
		
};
#endif
