/*!\file UpdateFromInputsx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateFromInputsx.h"

#undef __FUNCT__ 
#define __FUNCT__ "UpdateFromInputsx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

int UpdateFromInputsx( DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials, DataSet* parameters,ParameterInputs* inputs) {

	int noerr=1;
	int i;

	int  found=0;
	extern int num_procs;
	extern int my_rank;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials,parameters);
	loads->Configure(elements, loads, nodes, materials,parameters);
	nodes->Configure(elements, loads, nodes, materials,parameters);
	parameters->Configure(elements,loads, nodes, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	elements->UpdateFromInputs(inputs);
	nodes->UpdateFromInputs(inputs);
	loads->UpdateFromInputs(inputs);
	materials->UpdateFromInputs(inputs);

	return noerr;

}
