/*\file UpdateNodePositions.c
 *\brief: update node positions using new geometry defined by new bed and new thickness
 */

#include "./UpdateNodePositions.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL; 
	DataSet* parameters=NULL;
	Vec      thickness=NULL;
	Vec      bed=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateNodePositionsUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&thickness,THICKNESS);
	FetchData(&bed,BED);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateNodePositionsx(elements,nodes,loads, materials,parameters,thickness,bed);

	/*write output datasets: */
	WriteData(NODESOUT,nodes);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&thickness);
	VecFree(&bed);

	/*end module: */
	MODULEEND();
}

void UpdateNodePositionsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,loads, materials] = %s(elements,nodes,loads, materials,parameters, inputs);\n",__FUNCT__);
	_printf_("\n");
}
