/*\file UpdateFromInputs.c
 *\brief: update datasets with new parameter inputs
 */

#include "./UpdateFromInputs.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	ParameterInputs* inputs=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateFromInputsUsage);
	
	/*Input datasets: */
	FetchData(&elements,ELEMENTSIN);
	FetchData(&nodes,NODESIN);
	FetchData(&loads,LOADSIN);
	FetchData(&materials,MATERIALSIN);
	FetchParams(&parameters,PARAMETERSIN);
	
	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateFromInputsx(elements,nodes,loads, materials,parameters,inputs);
	
	/*write output datasets: */
	WriteData(ELEMENTS,elements);
	WriteData(NODES,nodes);
	WriteData(LOADS,loads);
	WriteData(MATERIALS,materials);
	WriteParams(PARAMETERS,parameters);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete parameters;
	delete inputs;
	
	/*end module: */
	MODULEEND();
}

void UpdateFromInputsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,loads, materials, parameters] = %s(elements,nodes,loads, materials,parameters,inputs);\n",__FUNCT__);
	_printf_("\n");
}
