/*\file Reducevectorgtos.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./Reducevectorgtos.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Vec yg=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Vec ys=NULL;
	Vec ys0=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReducevectorgtosUsage);

	/*Input datasets: */
	FetchData(&yg,YG);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce vector: */
	Reducevectorgtosx(&ys,&ys0, yg,nodesets);

	/*write output datasets: */
	WriteData(YS,ys);
	WriteData(YS0,ys0);

	/*Free ressources: */
	delete nodesets;
	VecFree(&yg);
	VecFree(&ys);
	VecFree(&ys0);

	/*end module: */
	MODULEEND();
}

void ReducevectorgtosUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [ys,ys0] = %s(yg,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
