/*\file InterpFromMeshToGrid.c
 *\brief: compute diff between observed and modeled velocity
 */

#include "./InterpFromMeshToGrid.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	double* index=NULL;
	int     nel;
	double* x=NULL;
	int     nods;
	double* y=NULL;
	double* meshdata=NULL;
	int     meshdata_length;
	double  cornereast;
	double  cornernorth;
	double  xposting;
	double  yposting;
	int     nlines,ncols;
	double  default_value;

	/* output datasets: */
	double* griddata=NULL;
	double* x_m=NULL;
	double* y_m=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InterpFromMeshToGridUsage);

	/*Input datasets: */
	FetchData(&index,&nel,NULL,INDEX);
	FetchData(&x,&nods,NULL,X);
	FetchData(&y,NULL,NULL,Y);
	FetchData(&meshdata,&meshdata_length,NULL,MESHDATA);
	FetchData(&cornereast,CORNEREAST);
	FetchData(&cornernorth,CORNERNORTH);
	FetchData(&xposting,XPOSTING);
	FetchData(&yposting,YPOSTING);
	FetchData(&nlines,NLINES);
	FetchData(&ncols,NCOLS);
	FetchData(&default_value,DEFAULTVALUE);

	/*Call core of computation: */
	InterpFromMeshToGridx(&x_m,&y_m,&griddata,index,x,y,nods,nel,meshdata,meshdata_length,cornereast,cornernorth,xposting,yposting,nlines,ncols,default_value);

	/*Write results: */
	WriteData(XM,x_m,ncols+1);
	WriteData(YM,y_m,nlines+1);
	WriteData(GRIDDATA,griddata,nlines,ncols);

	/*Free ressources: */
	//let matlab do this.
	
	/*end module: */
	MODULEEND();
}

void InterpFromMeshToGridUsage(void)
{
	_printf_("   usage:\n");
	_printf_("   [x_m,y_m,griddata]=InterpFromMeshToGrid(index,x,y,data,cornereast,cornernorth,xposting,yposting,nlines,ncols,default_value)\n");
	_printf_("\n");
	_printf_("   where:\n");
	_printf_("\n");
	_printf_("   index,x,y: delaunay triangulation defining the mesh.\n");
	_printf_("   meshdata: vertex values of data to be interpolated.\n");
	_printf_("   cornereast,cornernorth,posting,nlines,ncols: parameters that define the grid\n");
	_printf_("   default_value: value of points located out of the mesh.\n");
}
