/*!\file InterpFromGridToMesh.c
 * \brief: data interpolation from a list of (x,y,values) into mesh grids
 
	InterpFromGridToMesh.c

	usage:
	data_mesh=InterpFromGridToMesh(x,y,data,x_mesh,y_mesh);
	
	where:

		input:
		x,y: coordinates of matrix data
		data - matrix holding the data to be interpolated onto the mesh.
		x_mesh,y_mesh: coordinates of the mesh grids onto which we interpolate.
		
		output: 
		data_mesh:  vector of mesh interpolated data.

*/
	
#include "./InterpFromGridToMesh.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]) {

	int i,j;

	/*input: */
	double* x=NULL;
	double* y=NULL;

	int     x_rows;
	int     y_rows;

	double* data=NULL; 
	int     data_rows,data_cols;

	double* x_mesh=NULL;
	double* y_mesh=NULL;
	
	int     x_mesh_rows;
	int     y_mesh_rows;

	double default_value;

	/* output: */
	Vec  data_mesh=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InterpFromGridToMeshUsage);

	/*Input datasets: */
	FetchData(&x,&x_rows,NULL,XHANDLE);
	FetchData(&y,&y_rows,NULL,YHANDLE);
	FetchData(&data,&data_rows,&data_cols,DATAHANDLE);
	FetchData(&x_mesh,&x_mesh_rows,NULL,XMESHHANDLE);
	FetchData(&y_mesh,&y_mesh_rows,NULL,YMESHHANDLE);
	FetchData(&default_value,DEFAULTHANDLE);

	/* Run core computations: */
	InterpFromGridToMeshx( &data_mesh, x, x_rows,  y, y_rows, data, data_rows,data_cols, x_mesh, y_mesh, x_mesh_rows,default_value);

	/*Write data: */
	WriteData(DATAMESH,data_mesh);

	/*end module: */
	MODULEEND();
}

void InterpFromGridToMeshUsage(void)
{
	_printf_("   usage:\n");
	_printf_("   data_mesh=InterpFromGridToMesh(x,y,data,x_mesh,y_mesh,defult_value);\n\n");
	_printf_("   where:\n");
	_printf_("      x,y: coordinates of matrix data\n");
	_printf_("      data - matrix holding the data to be interpolated onto the mesh.\n");
	_printf_("      x_mesh,y_mesh: coordinates of the mesh grids onto which we interpolate.\n");
	_printf_("      default_value: default value if no interpolation is found.\n");
	_printf_("      data_mesh:  vector of mesh interpolated data.\n");
	_printf_("\n");
}
