/*!\file:  HoleFiller.cpp
 * \brief fill holes in matlab velocity array
	this matlab module is an adaptation of a routine written by Robber 
	Crippen.  The original routine was designed for the SRTM mission at JPL, 
	and can be found in the current directory, under the name 
	HoleFillerCrippen.  It fills void holes in an image, using an interpolation 
	algorithm, and optionnally a smoothing algorithm. 
	This matlab module extends the Crippen routine to be used in Matlab, 
	using double arrays found in the workspace, and loaded directly into memory.
*/


#include "./HoleFiller.h"

void mexFunction( int nlhs, mxArray* plhs[],
				  int nrhs, const mxArray* prhs[])
{

	int i,j,noerr;

	/* required input: */
	double* imagein=NULL;
	int     imagein_rows,imagein_cols;
	int     smooth_flag;
	int     smooth;


	/* output: */
	mxArray* pfield=NULL;
	double* imageout=NULL;
	int     imageout_rows,imageout_cols;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&HoleFillerUsage);

	/*Fetch data: */
	FetchData(&imagein,&imagein_rows,&imagein_cols,IMAGEIN);
	FetchData(&smooth_flag,SMOOTH);
	
	/*Get smooth flag setup: */
	if (smooth_flag==0)
		smooth=1;
	else
		smooth=0;

	/*Run core hole filler routine: */
	HoleFillerx( &imageout,imagein,imagein_rows,imagein_cols,smooth);

	/* output: */
	WriteData(IMAGEOUT,imageout,imagein_rows,imagein_cols);

	/*end module: */
	MODULEEND();
}


void HoleFillerUsage(void)
{
	printf("   HoleFiller usage:\n");
	printf("   [image_out]=HoleFiller(image_in,smooth);\n\n");
	printf("   where:\n");
	printf("      image_in in double format\n");
	printf("      smooth: 1 to smooth with a box filer, 0 to leave data raw\n");
	printf("      image_out in double format\n");
	printf("\n");
}
