function nightlyrun(varargin)
%NIGHTLYRUN - run the nighlty tests on 'tests/Verification'
%
%   This function goes to each directory of 'tests/Verifications' and
%   launches the nightly tests. A list of option can be given in input:
%     o analysis_type: cell containing all the analysis that the user wants to run
%     o sub_analysis_type: cell containing all the sub_analysis that the user wants to run
%     o qmu: 1 for qmu analysis only, 0 for no qmu analysis
%     o control: 1 for control only, 0 for no control
%     o control_fit: cell containing all the fits the user wants to run
%     o parallel: 1 for parallel only, 0 for serial only
%     o procedure: 'check' or 'update' to update archives
%     o rank: the node rank
%     o numprocs: number of cpus being used
%
%  Usage:
%      nightlyrun(varargin)
%
%   Example:
%      nightlyrun;
%      nightlyrun('analysis_type',{'prognostic','diagnostic'});
%      nightlyrun('procedure','update','analysis_type',{'prognostic','diagnostic'},'parallel',0);
%      nightlyrun('analysis_type',{'prognostic','diagnostic'},'parallel',1,'rank',1,'numprocs',3);

%use ISSM_DIR generated by startup.m
global ISSM_DIR

%recover options
options=optionlist2cell(varargin{:});

%check some options
rank=find_option(options,'rank');
if isempty(rank), rank=1; end
numprocs=find_option(options,'numprocs');
if (isempty(numprocs) | numprocs<rank), numprocs=1; end
procedure=find_option(options,'procedure');
if isempty(procedure), procedure='check'; end

%Go to Test directory
eval(['cd ' ISSM_DIR '/test/']);

%Run all verification tests
cd Verification

list=listfilesparallel(rank,numprocs);

%Go through list of decks, and run the deck runme.m files
for j=1:numel(list),
	eval(['cd ' list{j}]);
	runme('procedure',procedure,varargin{:});
	cd ..
end
