/*!\file Numpar.c
 * \brief: implementation of the Numpar object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./Numpar.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"


Numpar::Numpar(){
	return;
}

Numpar::Numpar(int numpar_id){
	id=numpar_id;

	meanvel=UNDEF;
	epsvel=UNDEF;
	artdiff=UNDEF;
	viscosity_overshoot=UNDEF;
	stokesreconditioning=UNDEF;
	cm_noisedampening=UNDEF;

	return;
}
Numpar::~Numpar(){
	return;
}

Numpar::Numpar(int    numpar_id, double numpar_meanvel, double numpar_epsvel, int    numpar_artdiff, double numpar_viscosity_overshoot, double numpar_stokesreconditioning, double numpar_cm_noisedampening){

	id=numpar_id;
	meanvel=numpar_meanvel;
	epsvel=numpar_epsvel;
	artdiff=numpar_artdiff;
	viscosity_overshoot=numpar_viscosity_overshoot;
	stokesreconditioning=numpar_stokesreconditioning;
	cm_noisedampening=numpar_cm_noisedampening;
	
}

#undef __FUNCT__
#define __FUNCT__ "Numpar::Echo"
void Numpar::Echo(void){

	printf("Numpar:\n");
	printf("   id: %i\n",id);
	printf("   meanvel: %g\n",meanvel);
	printf("   epsvel: %g\n",epsvel);
	printf("   artdiff: %i\n",artdiff);
	printf("   viscosity_overshoot: %g\n",viscosity_overshoot);
	printf("   stokesreconditioning: %g\n",stokesreconditioning);
	printf("   cm_noisedampening: %g\n",cm_noisedampening);
}

#undef __FUNCT__
#define __FUNCT__ "Numpar::DeepEcho"
void Numpar::DeepEcho(void){

	printf("Numpar:\n");
	printf("   id: %i\n",id);
	printf("   meanvel: %g\n",meanvel);
	printf("   epsvel: %g\n",epsvel);
	printf("   artdiff: %i\n",artdiff);
	printf("   viscosity_overshoot: %g\n",viscosity_overshoot);
	printf("   stokesreconditioning: %g\n",stokesreconditioning);
	printf("   cm_noisedampening: %g\n",cm_noisedampening);
}


void  Numpar::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Numpar: */
	enum_type=NumparEnum();
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Numpar data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&meanvel,sizeof(meanvel));marshalled_dataset+=sizeof(meanvel);
	memcpy(marshalled_dataset,&epsvel,sizeof(epsvel));marshalled_dataset+=sizeof(epsvel);
	memcpy(marshalled_dataset,&artdiff,sizeof(artdiff));marshalled_dataset+=sizeof(artdiff);
	memcpy(marshalled_dataset,&viscosity_overshoot,sizeof(viscosity_overshoot));marshalled_dataset+=sizeof(viscosity_overshoot);
	memcpy(marshalled_dataset,&stokesreconditioning,sizeof(stokesreconditioning));marshalled_dataset+=sizeof(stokesreconditioning);
	memcpy(marshalled_dataset,&cm_noisedampening,sizeof(cm_noisedampening));marshalled_dataset+=sizeof(cm_noisedampening);
	
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
		
int   Numpar::MarshallSize(){
	return sizeof(id)
		+sizeof(meanvel)
		+sizeof(epsvel)
		+sizeof(artdiff)
		+sizeof(viscosity_overshoot)
		+sizeof(stokesreconditioning)
		+sizeof(cm_noisedampening)
		+sizeof(int); //sizeof(int) for enum type
}

char* Numpar::GetName(void){
	return "beam";
}

void  Numpar::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&meanvel,marshalled_dataset,sizeof(meanvel));marshalled_dataset+=sizeof(meanvel);
	memcpy(&epsvel,marshalled_dataset,sizeof(epsvel));marshalled_dataset+=sizeof(epsvel);
	memcpy(&artdiff,marshalled_dataset,sizeof(artdiff));marshalled_dataset+=sizeof(artdiff);
	memcpy(&viscosity_overshoot,marshalled_dataset,sizeof(viscosity_overshoot));marshalled_dataset+=sizeof(viscosity_overshoot);
	memcpy(&stokesreconditioning,marshalled_dataset,sizeof(stokesreconditioning));marshalled_dataset+=sizeof(stokesreconditioning);
	memcpy(&cm_noisedampening,marshalled_dataset,sizeof(cm_noisedampening));marshalled_dataset+=sizeof(cm_noisedampening);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
int Numpar::Enum(void){

	return NumparEnum();

}
int    Numpar::GetId(void){ return id; }

int    Numpar::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}


#undef __FUNCT__ 
#define __FUNCT__ "Numpar::Configure"
void  Numpar::Configure(void* pparametersin){

	DataSet* parameters=NULL;

	/*Recover virtual pointer:*/
	parameters=(DataSet*)pparametersin;

	/*Go through parameters dataset, and find the Param object corresponding to our fields, 
	 * and update the fields: */
	if(!parameters->FindParam(&meanvel,"meanvel"))throw ErrorException(__FUNCT__," error message: could not update meanvel field");
	if(!parameters->FindParam(&epsvel,"epsvel"))throw ErrorException(__FUNCT__," error message: could not update epsvel field");
	if(!parameters->FindParam(&artdiff,"artdiff"))throw ErrorException(__FUNCT__," error message: could not update artdiff field");
	if(!parameters->FindParam(&viscosity_overshoot,"viscosity_overshoot"))throw ErrorException(__FUNCT__," error message: could not update viscosity_overshoot field");
	if(!parameters->FindParam(&stokesreconditioning,"stokesreconditioning"))throw ErrorException(__FUNCT__," error message: could not update stokesreconditioning field");
	if(!parameters->FindParam(&cm_noisedampening,"cm_noisedampening"))throw ErrorException(__FUNCT__," error message: could not update cm_noisedampening field");

	return;
}


#undef __FUNCT__ 
#define __FUNCT__ "Numpar::UpdateFromInputs"
void  Numpar::UpdateFromInputs(void* vinputs){

	ParameterInputs* inputs=NULL;

	/*recover pointers: */
	inputs=(ParameterInputs*)vinputs;

	/*Update internal data if inputs holds new values: */
	inputs->Recover("meanvel",&meanvel);
	inputs->Recover("epsvel",&epsvel);
	inputs->Recover("artdiff",&artdiff);
	inputs->Recover("viscosity_overshoot",&viscosity_overshoot);
	inputs->Recover("stokesreconditioning",&stokesreconditioning);
	inputs->Recover("cm_noisedampening",&cm_noisedampening);

}
		
Object* Numpar::copy() {
	
	return new Numpar(*this); 

}

