/*! \file Model.h 
 *  \brief: header file for model object
 */

#ifndef _MODEL_H_
#define _MODEL_H_

#include "../include/types.h"

struct FemModel;
class DataSet;

class Model{

	private: 

		/*femmodels for each formulation: dynamic, can have as many*/
		DataSet* femmodels;
		
		/*active femmodel: points to a FemModel in the femmodels dataset*/
		FemModel* active;

	public:

		Model();
		~Model();

		void  Echo();
		void  DeepEcho();

		void  AddFormulation(ConstDataHandle MODEL, int analysis_type,int sub_analysis_type);
		void  AddFormulation(ConstDataHandle MODEL, int analysis_type);

		/*all overloaded forms of the FindParam routine: */
		int   FindParam(int* pparameter,char* parametername);
		int   FindParam(double* pparameter,char* parametername);
		int   FindParam(double** pparameter,int* pM,int* pN,char* parametername);
		int   FindParam(char** pparameter,char* parametername);

		int   FindParam(int* pparameter,char* parametername,int analysis_type,int sub_analysis_type);
		int   FindParam(double* pparameter,char* parametername,int analysis_type,int sub_analysis_type);
		int   FindParam(double** pparameter,int* pM, int* pN,char* parametername,int analysis_type,int sub_analysis_type);
		int   FindParam(char** pparameter,char* parametername,int analysis_type,int sub_analysis_type);

		int   FindParam(int* pparameter,char* parametername,int analysis_type);
		int   FindParam(double* pparameter,char* parametername,int analysis_type);
		int   FindParam(double** pparameter,int* pM,int* pN,char* parametername,int analysis_type);
		int   FindParam(char** pparameter,char* parametername,int analysis_type);

		FemModel* GetFormulation(int analysis_type,int sub_analysis_type);
		FemModel* GetFormulation(int analysis_type);

		FemModel* GetActiveFormulation();
		void* SetActiveFormulation(FemModel* femmodel);

};
#endif  /* _MODEL_H */
