/*!\file: CreateParametersMelting.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersMelting"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void CreateParametersMelting(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* melting=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	/*if 2d: return*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	count=parameters->Size();

	/* get initial melting if transient*/
	if(iomodel->dt){

		/*Get melting: */
		IoModelFetchData(&melting,NULL,NULL,iomodel_handle,"melting");
		if(melting) {
			for(i=0;i<iomodel->numberofnodes;i++)melting[i]=melting[i]/iomodel->yts;   //m/s instead of m/yr
		}
		else{
			for(i=0;i<iomodel->numberofnodes;i++)melting[i]=0;
		}

		count++;
		param= new Param(count,"m_g",DOUBLEVEC);
		if(melting) param->SetDoubleVec(melting,iomodel->numberofnodes);
		else param->SetDoubleVec(melting,0);
		parameters->AddObject(param);

		/*Free melting: */
		xfree((void**)&melting);
	}

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
