/*
 * CreateConstraintsDiagnosticHutter.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateConstraintsDiagnosticHutter"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"


void	CreateConstraintsDiagnosticHutter(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i,j;
	int count;

	DataSet* constraints = NULL;

	Spc*    spc  = NULL;
	Rgb*    rgb  = NULL;

	/*spc intermediary data: */
	int spc_sid;
	int spc_node;
	int spc_dof;
	double spc_value;

	/*rgb constructor data: */
	int rgb_id;
	int rgb_dof;
	int rgb_nodeid1;
	int rgb_nodeid2;

	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->ishutter)goto cleanup_and_return;

	count=0;
	
	/*Fetch data: */
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");

	/*vx and vy are spc'd if we are not on gridonhutter: */
	for (i=0;i<iomodel->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((iomodel->my_grids[i])){
	#endif

		if (!(int)iomodel->gridonhutter[i]){
	
			spc_sid=count;
			spc_node=i+1;
			spc_dof=1; //we enforce first x translation degree of freedom
			spc_value=0;

			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;

			spc_sid=count;
			spc_node=i+1;
			spc_dof=2; //we enforce first y translation degree of freedom
			spc_value=0;
			
			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;
		}

	#ifdef _PARALLEL_
	} //if((my_grids[i]))
	#endif
	}

	/*Free data: */
	xfree((void**)&iomodel->gridonhutter);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
