/*\file UpdateGeometry.c
 *\brief: update geometry from new thickness computed by prognostic_core.
 */

#include "./UpdateGeometry.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	Vec      newthickness=NULL;
	Vec      bed=NULL;
	Vec      surface=NULL;

	/* output datasets: */
	Vec outbed=NULL;
	Vec outsurface=NULL;
	Vec outthickness=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateGeometryUsage);
        
	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	
	FetchData(&newthickness,NEWTHICKNESS);
	FetchData(&bed,BED);
	FetchData(&surface,SURFACE);

	/*!Generate internal degree of freedom numbers: */
	UpdateGeometryx(&outthickness,&outbed,&outsurface, elements, nodes,loads, materials, parameters,newthickness,bed,surface);

	/*write output data: */
	WriteData(OUTTHICKNESS,outthickness);
	WriteData(OUTBED,outbed);
	WriteData(OUTSURFACE,outsurface);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&newthickness);
	VecFree(&bed);
	VecFree(&surface);
	VecFree(&outbed);
	VecFree(&outthickness);
	VecFree(&outsurface);

	/*end module: */
	MODULEEND();
}

void UpdateGeometryUsage(void) {
	_printf_("\n");
	_printf_("   usage: [outthickness,outbed,outsrface] = %s(elements, nodes, materials, parameters,newthickness,bed,surface);\n",__FUNCT__);
	_printf_("\n");
}
