/*\file PenaltyConstraints.c
 *\brief: set up penalty constraints
 */

#include "./PenaltyConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	ParameterInputs* inputs=NULL;
	int               analysis_type;
	int               sub_analysis_type;

	/*output: */
	int converged;
	int num_unstable_constraints;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PenaltyConstraintsUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&loads,LOADSIN);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*parameters: */
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Generate internal degree of freedom numbers: */
	PenaltyConstraintsx(&converged, &num_unstable_constraints, elements,nodes,loads,materials,parameters,inputs,analysis_type,sub_analysis_type); 

	/*write output datasets: */
	WriteData(LOADS,loads);
	WriteData(CONVERGED,converged);
	WriteData(NUMUNSTABLECONSTRAINTS,num_unstable_constraints);
	
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete parameters;
	delete inputs;

	/*end module: */
	MODULEEND();
}

void PenaltyConstraintsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [loads, constraints_converged, num_unstable_constraints] = %s(elements,nodes,loads,materials,params,inputs,analysis_type,sub_analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
