/*\file MassFlux.c
 *\brief: compute mass flux along a profile.
 */

#include "./MassFlux.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* parameters=NULL;
	double*  segments=NULL;
	int      num_segments;
	double*  ug=NULL;
	mxArray* pfield=NULL;

	/* output datasets: */
	double   mass_flux;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MassFluxUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	parameters->FindParam(&segments,&num_segments,NULL,"qmu_mass_flux_segments");

	/*results: */
	FetchData(&ug,NULL,NULL,UG);

	/*!Compute mass flux along the profile: */
	MassFluxx(&mass_flux, elements,nodes,loads,materials,parameters,segments,num_segments,ug);

	/*write output datasets: */
	WriteData(RESPONSE,mass_flux);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&ug);

	/*end module: */
	MODULEEND();
}

void MassFluxUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(eleemnts,nodes,loads,materials,params,inputs,analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
