/*\file ControlOptimization.c
 *\brief: control optimization (replaces fmincon from matlab)
 */
 

#include "./ControlOptimization.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	char* function_name=NULL;
	double xmin,xmax;
	double tolerance;
	int    maxiter;
	OptArgs optargs;
	OptPars optpars;

	/*output: */
	double search_scalar;
	double J;

	/*arguments to objectivefunctionC: */
	mxArray* models=NULL;
	mxArray* pg=NULL;
	mxArray* grad_g=NULL;
	mxArray* n=NULL;
	int      n_value;
	double*  cm_jump=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlOptimizationUsage);

	/*Input datasets: */
	FetchData(&function_name,FUNCTIONNAME);
	FetchData(&xmin,XMIN);
	FetchData(&xmax,XMAX);
	FetchData(&tolerance,mxGetField(OPTIONS,0,"TolX"));
	FetchData(&maxiter,mxGetField(OPTIONS,0,"MaxIter"));

	/*Parameters: */
	FetchData(&cm_jump,NULL,NULL,mxGetField(PARAMETERS,0,"cm_jump"));
	FetchData(&n_value,STEP);

	optargs.function_name=function_name;
	optargs.models=MODELS;
	optargs.param_g=PG; 
	optargs.inputs=INPUTS;
	optargs.grad_g=GRADIENT;
	optargs.n=STEP;
	optargs.analysis_type=mxGetField(PARAMETERS,0,"analysis_type");
	optargs.sub_analysis_type=mxGetField(PARAMETERS,0,"sub_analysis_type");

	optpars.xmin=xmin;
	optpars.xmax=xmax;
	optpars.tolerance=tolerance;
	optpars.maxiter=maxiter;
	optpars.cm_jump=cm_jump[n_value-1];

	BrentSearch(&search_scalar,&J,&optpars,&OptFunc,&optargs);

	/*write output : */
	WriteData(SEARCHSCALAR,search_scalar);
	WriteData(MISFIT,J);

	/*Free ressources: */
	xfree((void**)&function_name);
	xfree((void**)&cm_jump);

	/*end module: */
	MODULEEND();
}

void ControlOptimizationUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [search_scalar J] = %s(function_name,xmin,xmax,options,m,inputs,p_g,grad_g,step,parameters)\n",__FUNCT__);
	_printf_("\n");
}
