/*!\file: CreateParametersThermal.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersThermal"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void CreateParametersThermal(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* u_g=NULL;
	double* pressure=NULL;
	double* temperature=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	/*return if 2d mesh*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	count=parameters->Size();

	/*Get vx vy and vz: */
	IoModelFetchData(&vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&vy,NULL,NULL,iomodel_handle,"vy");
	IoModelFetchData(&vz,NULL,NULL,iomodel_handle,"vz");

	u_g=(double*)xcalloc(iomodel->numberofnodes*3,sizeof(double));

	if(vx) for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+0]=vx[i]/iomodel->yts;
	if(vy) for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+1]=vy[i]/iomodel->yts;
	if(vz) for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+2]=vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*iomodel->numberofnodes,3);
	parameters->AddObject(param);

	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);
	
	/*Get pressure: */
	IoModelFetchData(&pressure,NULL,NULL,iomodel_handle,"pressure");
	
	count++;
	param= new Param(count,"p_g",DOUBLEVEC);
	if(pressure) param->SetDoubleVec(pressure,iomodel->numberofnodes,1);
	else param->SetDoubleVec(pressure,0,0);
	parameters->AddObject(param);

	/*Free pressure: */
	xfree((void**)&pressure);

	/* get initial temperature and melting if transient*/
	if(iomodel->dt){

		/*Get melting and temperature: */
		IoModelFetchData(&temperature,NULL,NULL,iomodel_handle,"temperature");

		count++;
		param= new Param(count,"t_g",DOUBLEVEC);
		if(temperature) param->SetDoubleVec(temperature,iomodel->numberofnodes,1);
		else throw ErrorException(__FUNCT__,exprintf("Missing initial temperature"));
		parameters->AddObject(param);

		/*Free temperature: */
		xfree((void**)&temperature);
	}

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
