/*
 * CreateElementsNodesAndMaterialsDiagnosticHutter.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateElementsNodesAndMaterialsDiagnosticHutter"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../IoModel.h"


void	CreateElementsNodesAndMaterialsDiagnosticHutter(DataSet** pelements,DataSet** pnodes, DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle){


	int i,k;
	extern int my_rank;
	extern int num_procs;

	/*DataSets: */
	DataSet*    elements  = NULL;
	DataSet*    nodes = NULL;
	DataSet*    materials = NULL;
	
	/*Objects: */
	Node*       node   = NULL;
	Matice*     matice = NULL;
	Matpar*     matpar = NULL;
	Beam*       beam   = NULL;
	Sing*       sing   = NULL;

	/*output: */
	int* epart=NULL; //element partitioning.
	int* npart=NULL; //node partitioning.
	int* my_grids=NULL;
	double* my_bordergrids=NULL;

	/*intermediary: */
	int elements_width; //size of elements
	double B_avg;
			
	/*matice constructor input: */
	int    matice_mid;
	double matice_B;
	double matice_n;

	/*sing constructor input: */
	int   sing_id;
	int   sing_mid;
	int   sing_mparid;
	int   sing_numparid;
	int   sing_g;
	double sing_h,sing_k;

	/*beam constructor input: */
	int   beam_id;
	int   beam_mid;
	int   beam_mparid;
	int   beam_numparid;
	int   beam_g[2];
	double beam_h[2];
	double beam_s[2];
	double beam_b[2];
	double beam_k[2];
	bool    beam_onbed;
					
	/*matpar constructor input: */
	int	matpar_mid;
	double matpar_rho_ice; 
	double matpar_rho_water;
	double matpar_heatcapacity;
	double matpar_thermalconductivity;
	double matpar_latentheat;
	double matpar_beta;
	double matpar_meltingpoint;
	double matpar_mixed_layer_capacity;
	double matpar_thermal_exchange_velocity;
	double matpar_g;

	/* node constructor input: */
	int node_id;
	int node_partitionborder=0;
	double node_x[3];
	double node_sigma;
	int node_onbed;
	int node_onsurface;
	int node_onshelf;
	int node_onsheet;
	int node_upper_node_id;
	int node_numdofs;

	#ifdef _PARALLEL_
	/*Metis partitioning: */
	int  range;
	Vec  gridborder=NULL;
	int  my_numgrids;
	int* all_numgrids=NULL;
	int  gridcount;
	int  count;
	#endif

	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum());
	nodes     = new DataSet(NodesEnum());
	materials = new DataSet(MaterialsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->ishutter)goto cleanup_and_return;

	/*Width of elements: */
	if(strcmp(iomodel->meshtype,"2d")==0){
		elements_width=3; //tria elements
	}
	else{
		elements_width=6; //penta elements
	}

	#ifdef _PARALLEL_
	/*Determine parallel partitioning of elements: we use Metis for now. First load the data, then partition*/
	if(strcmp(iomodel->meshtype,"2d")==0){
		/*load elements: */
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	}
	else{
		/*load elements2d: */
		IoModelFetchData(&iomodel->elements2d,NULL,NULL,iomodel_handle,"elements2d");
	}

	MeshPartitionx(&epart, &npart,iomodel->numberofelements,iomodel->numberofnodes,iomodel->elements, iomodel->numberofelements2d,iomodel->numberofnodes2d,iomodel->elements2d,iomodel->numlayers,elements_width, iomodel->meshtype,num_procs);

	/*Free elements and elements2d: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->elements2d);

	/*Used later on: */
	my_grids=(int*)xcalloc(iomodel->numberofnodes,sizeof(int));
	#endif

	#ifdef _PARALLEL_
	if(strcmp(iomodel->meshtype,"2d")==0){
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		for (i=0;i<iomodel->numberofelements;i++){
			if(my_rank==epart[i]){ 
				/*Now that we are here, we can also start building the list of grids belonging to this node partition: we use 
				 *the  element index to do this. For each element n, we know index[n][0:2] holds the indices (matlab indexing) 
				 into the grid coordinates. If we start plugging 1 into my_grids for each index[n][i] (i=0:2), then my_grids 
				 will hold which grids belong to this partition*/

				my_grids[(int)*(iomodel->elements+elements_width*i+0)-1]=1;
				my_grids[(int)*(iomodel->elements+elements_width*i+1)-1]=1;
				my_grids[(int)*(iomodel->elements+elements_width*i+2)-1]=1;
			}
		}
	}
	else{
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		for (i=0;i<iomodel->numberofelements;i++){
			if(my_rank==epart[i]){ 
				my_grids[(int)*(iomodel->elements+elements_width*i+0)-1]=1;
				my_grids[(int)*(iomodel->elements+elements_width*i+1)-1]=1;
				my_grids[(int)*(iomodel->elements+elements_width*i+2)-1]=1;
				my_grids[(int)*(iomodel->elements+elements_width*i+3)-1]=1;
				my_grids[(int)*(iomodel->elements+elements_width*i+4)-1]=1;
				my_grids[(int)*(iomodel->elements+elements_width*i+5)-1]=1;
			}
		}
	}

	/*From the element partitioning, we can determine which grids are on the inside of this cpu's 
	 *element partition, and which are on its border with other nodes:*/
	gridborder=NewVec(iomodel->numberofnodes);

	for (i=0;i<iomodel->numberofnodes;i++){
		if(my_grids[i])VecSetValue(gridborder,i,1,ADD_VALUES);
	}
	VecAssemblyBegin(gridborder);
	VecAssemblyEnd(gridborder);

	#ifdef _ISSM_DEBUG_
	VecView(gridborder,PETSC_VIEWER_STDOUT_WORLD);
	#endif
	
	VecToMPISerial(&my_bordergrids,gridborder);

	#ifdef _ISSM_DEBUG_
	if(my_rank==0){
		for (i=0;i<iomodel->numberofnodes;i++){
			printf("Grid id %i Border grid %lf\n",i+1,my_bordergrids[i]);
		}
	}
	#endif
	#endif

	/*Hutter elements can be partitioned using epart, even if
	 * each hutter elements either lies on a node (in 2d), or a pair of vertically juxtaposed nodes (in 3d): */

	/*Fetch data temporarily needed: */
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	IoModelFetchData(&iomodel->drag,NULL,NULL,iomodel_handle,"drag");
	IoModelFetchData(&iomodel->B,NULL,NULL,iomodel_handle,"B");
	IoModelFetchData(&iomodel->n,NULL,NULL,iomodel_handle,"n");

	/*2d mesh: */
	if (strcmp(iomodel->meshtype,"2d")==0){

		for (i=0;i<iomodel->numberofnodes;i++){
		#ifdef _PARALLEL_
		/*keep only this partition's nodes:*/
		if(my_grids[i]){
		#endif

			if(iomodel->gridonhutter[i]){
				
				/*Deal with sing element: */
				sing_id=i+1; 
				sing_mid=i+1; //refers to the corresponding material property card
				sing_mparid=iomodel->numberofnodes+1;//refers to the corresponding matpar property card
				sing_numparid=1;
				sing_g=i+1;
				sing_h=iomodel->thickness[i];
				sing_k=iomodel->drag[i];

				/*Create sing element using its constructor:*/
				sing=new Sing(sing_id, sing_mid, sing_mparid, sing_numparid, sing_g, sing_h, sing_k);

				/*Add tria element to elements dataset: */
				elements->AddObject(sing);

				/*Deal with material property card: */
				matice_mid=i+1; //same as the material id from the geom2 elements.
				matice_B=iomodel->B[i];	
				matice_n=(double)iomodel->n[1]; //n defined on elements not grids, so take the first value everywhere
			
				/*Create matice using its constructor:*/
				matice= new Matice(matice_mid,matice_B,matice_n);
	
				/*Add matice element to materials dataset: */
				materials->AddObject(matice);
			}

		#ifdef _PARALLEL_
		} //if(my_rank==npart[i])
		#endif

		} //for (i=0;i<iomodel->numberofnodes;i++)
	} //if (strcmp(iomodel->meshtype,"2d")==0)
	else{

		for (i=0;i<iomodel->numberofnodes;i++){
		#ifdef _PARALLEL_
		/*keep only this partition's nodes:*/
		if(my_grids[i]){
		#endif

			if(iomodel->gridonhutter[i]){

				if(!iomodel->gridonsurface[i]){ 
					
					/*Deal with sing element: */
					beam_id=i+1; 
					beam_mid=i+1; //refers to the corresponding material property card
					beam_mparid=iomodel->numberofnodes-iomodel->numberofnodes2d+1;//refers to the corresponding matpar property card
					beam_numparid=1;
					beam_g[0]=i+1;
					beam_g[1]=(int)iomodel->uppernodes[i]; //grid that lays right on top
					beam_h[0]=iomodel->thickness[i];
					beam_h[1]=iomodel->thickness[(int)(iomodel->uppernodes[i]-1)];
					beam_s[0]=iomodel->surface[i];
					beam_s[1]=iomodel->surface[(int)(iomodel->uppernodes[i]-1)];
					beam_b[0]=iomodel->bed[i];
					beam_b[1]=iomodel->bed[(int)(iomodel->uppernodes[i]-1)];
					beam_k[0]=iomodel->drag[i];
					beam_k[1]=iomodel->drag[(int)(iomodel->uppernodes[i]-1)];

					beam_onbed=(bool)iomodel->gridonbed[i];

					/*Create beam element ubeam its constructor:*/
					beam=new Beam(beam_id, beam_mid, beam_mparid, beam_numparid,beam_g, beam_h, beam_s,beam_b,beam_k,beam_onbed);

					/*Add tria element to elements dataset: */
					elements->AddObject(beam);

					/*Deal with material property card: */
					matice_mid=i+1; //same as the material id from the geom2 elements.
					matice_B=iomodel->B[i];	
					matice_n=(double)iomodel->n[1]; //n defined on elements not grids, so take the first value everywhere
				
					/*Create matice ubeam its constructor:*/
					matice= new Matice(matice_mid,matice_B,matice_n);
		
					/*Add matice element to materials dataset: */
					materials->AddObject(matice);
				}
			}

		#ifdef _PARALLEL_
		} //if(my_rank==npart[i])
		#endif

		} //for (i=0;i<iomodel->numberofnodes;i++)

	} //if (strcmp(iomodel->meshtype,"2d")==0)
	

	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->drag);
	xfree((void**)&iomodel->B);
	xfree((void**)&iomodel->n);
	

	/*Add one constant material property to materials: */
	matpar_mid=iomodel->numberofnodes-iomodel->numberofnodes2d+1; //put it at the end of the materials
	matpar_g=iomodel->g; 
	matpar_rho_ice=iomodel->rho_ice; 
	matpar_rho_water=iomodel->rho_water; 
	matpar_thermalconductivity=iomodel->thermalconductivity; 
	matpar_heatcapacity=iomodel->heatcapacity; 
	matpar_latentheat=iomodel->latentheat; 
	matpar_beta=iomodel->beta; 
	matpar_meltingpoint=iomodel->meltingpoint; 
	matpar_mixed_layer_capacity=iomodel->mixed_layer_capacity; 
	matpar_thermal_exchange_velocity=iomodel->thermal_exchange_velocity; 

	/*Create matpar object using its constructor: */
	matpar=new Matpar(matpar_mid,matpar_rho_ice,matpar_rho_water,matpar_heatcapacity,matpar_thermalconductivity,
			matpar_latentheat,matpar_beta,matpar_meltingpoint,matpar_mixed_layer_capacity,
			matpar_thermal_exchange_velocity,matpar_g);
		
	/*Add to materials datset: */
	materials->AddObject(matpar);
	
	/*Create nodes from x,y,z, as well as the spc values on those grids: */
		
	/*First fetch data: */
	if (strcmp(iomodel->meshtype,"3d")==0){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}
	IoModelFetchData(&iomodel->x,NULL,NULL,iomodel_handle,"x");
	IoModelFetchData(&iomodel->y,NULL,NULL,iomodel_handle,"y");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	
	/*Get number of dofs per node: */
	DistributeNumDofs(&node_numdofs,iomodel->analysis_type,iomodel->sub_analysis_type);

	for (i=0;i<iomodel->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if(my_grids[i]){
	#endif

		node_id=i+1; //matlab indexing
			

		#ifdef _PARALLEL_
		if(my_bordergrids[i]>1.0) { //this grid belongs to a partition border
			node_partitionborder=1;
		}
		else{
			node_partitionborder=0;
		}
		#else
			node_partitionborder=0;
		#endif

		node_x[0]=iomodel->x[i];
		node_x[1]=iomodel->y[i];
		node_x[2]=iomodel->z[i];
		node_sigma=(iomodel->z[i]-iomodel->bed[i])/(iomodel->thickness[i]);
		
		node_onbed=(int)iomodel->gridonbed[i];
		node_onsurface=(int)iomodel->gridonsurface[i];	
		node_onshelf=(int)iomodel->gridoniceshelf[i];	
		node_onsheet=(int)iomodel->gridonicesheet[i];	

		if (strcmp(iomodel->meshtype,"3d")==0){
			if (isnan(iomodel->uppernodes[i])){
				node_upper_node_id=node_id;  //nodes on surface do not have upper nodes, only themselves.
			}
			else{
				node_upper_node_id=(int)iomodel->uppernodes[i];
			}
		}
		else{
			/*If we are running 2d, upper_node does not mean much. Just point towards itself!:*/
			node_upper_node_id=node_id;
		}

		/*Create node using its constructor: */
		node=new Node(node_id,node_partitionborder,node_numdofs,node_x,node_sigma,node_onbed,node_onsurface,node_upper_node_id,node_onshelf,node_onsheet);

		/*set single point constraints.: */
		if (!iomodel->gridonhutter[i]){
			for(k=1;k<=node_numdofs;k++){
				node->FreezeDof(k);
			}
		}

		/*Add node to nodes dataset: */
		nodes->AddObject(node);

	#ifdef _PARALLEL_
	} //if(my_grids[i])
	#endif
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	elements->Presort();
	nodes->Presort();
	materials->Presort();

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);
	

	/*Keep partitioning information into iomodel*/
	iomodel->epart=epart;
	iomodel->my_grids=my_grids;
	iomodel->my_bordergrids=my_bordergrids;

	/*Keep partitioning information into iomodel*/
	#ifdef _PARALLEL_
	xfree((void**)&all_numgrids);
	xfree((void**)&npart);
	VecFree(&gridborder);
	#endif
	iomodel->npart=npart;

	cleanup_and_return:

	/*Assign output pointer: */
	*pelements=elements;
	*pnodes=nodes;
	*pmaterials=materials;

}
