function md=solveparallel(md,options)
%SOLVEPARALLEL - solution sequence using a cluster in parallel mode
%
%   Usage:
%      md=solveparallel(md);

%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%Figure out parameters for this particular cluster
[codepath,executionpath]=ClusterParameters(md.cluster,cluster_rc_location);

%Marshall model data into a binary file.
marshall(md);

%add qmu fields to binary file if running qmu analysis
if md.qmu_analysis,
	qmumarshall(md,md.variables(options.ivar),md.responses(options.iresp));
end

%Now, we need to build the queuing script, used by the cluster to launch the job.
BuildQueueingScript(md,executionpath,codepath);

%Now, launch the queueing script
md=LaunchQueueJob(md,executionpath,options);

%timing 
t1=clock;

%Do we return, or just wait for results?
if md.waitonlock~=0,
	%we wait for the done file
	islock=waitonlock([executionpath '/' md.name '.lock'],md.waitonlock);
	if islock==0,
		%no results to be loaded
		disp('The results must be loaded manually with loadmodelfromcluster.');
		error(['solveparallel info message: time limit exceeded'])
	else
		%load results
		%stop timing
		t2=clock;
		displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);

		displaystring(md.verbose,'loading results from cluster');
		md=loadresultsfromcluster(md);
	end
end
