#!/bin/bash

# Source Windows environment
source $ISSM_DIR/externalpackages/windows/windows_environment.sh

echo "Making generic_static.m work like generic.m"
cd $ISSM_DIR/bin
cat generic_static.m | sed -e "s/generic_static/generic/g" > generic.m

echo "Copying scripts from /src to /bin"
echo "----------------------------------"
rm $ISSM_DIR/bin/*.m
find $ISSM_DIR/src/m -name '*.m' | xargs cp -t $ISSM_DIR/bin
ls $ISSM_DIR/bin
echo "----------------------------------"

# Check that test 101 runs
cd $ISSM_DIR/test/NightlyRun
rm matlab.log

$MATLAB_PATH/bin/matlab -nodisplay -nosplash -r "try, addpath $ISSM_DIR_WIN/bin $ISSM_DIR_WIN/lib; runme('id',101); exit; catch me,fprintf('%s',getReport(me)); exit; end" -logfile matlab.log

if [[ $(cat matlab.log | grep -c SUCCESS) -lt 10 ]]; then
	echo "test101 FAILED"
	exit 1;
else
	echo "test101 passed"
fi

# Create tarball
TARBALL_NAME=ISSM-Win10-64.tar.gz

cd $ISSM_DIR
rm $tarball_name
rm -rf trunk
mkdir trunk

echo "Creating tarball: ${TARBALL_NAME}"
cp -rf bin lib test examples scripts trunk/
tar -czf $TARBALL_NAME trunk
ls -lah $TARBALL_NAME


#To upload to website:
scp $TARBALL_NAME websites:/home/larour/files/$TARBALL_NAME
