function optionstruct=modeldefault_process(options),
%MODELDEFAULT_PROCESS - process modeldefault options
%
%   Usage:
%      optionstruct=modeldefault_process(options)

%retrieve some paths
global ISSM_DIR
modeldatapath='/u/astrid-r1b/larour/ModelData';

%initialize output
optionstruct=struct();

%domainoutline
optionstruct.domainoutline=find_option(options,'domainoutline');
if isempty(optionstruct.domainoutline),
	error('modeldefault_process error pessage: at least the option ''domainoutline'' must be specified')
end

%resolution
optionstruct.resolution=find_option(options,'resolution');
if isempty(optionstruct.resolution),
	optionstruct.resolution=10000;
end
disp(sprintf('   %-18s: %g','resolution',optionstruct.resolution));

%iceshelves
optionstruct.iceshelves=find_option(options,'iceshelves');
if isempty(optionstruct.iceshelves),
	iceshelves=[ISSM_DIR '/../models/Antarctica/Exp_Par/Iceshelves.exp'];
	if exist(iceshelves),
		optionstruct.iceshelves=iceshelves;
	else
		optionstruct.iceshelves='';
	end
end
disp(sprintf('   %-18s: %s','iceshelves',optionstruct.iceshelves));

%islands
optionstruct.islands=find_option(options,'islands');
if isempty(optionstruct.islands),
	islands=[ISSM_DIR '/../models/Antarctica/Exp_Par/Islands.exp'];
	if exist(islands),
		optionstruct.islands=islands;
	else
		optionstruct.islands='';
	end
end
disp(sprintf('   %-18s: %s','islands',optionstruct.islands));

%thicknesspath
optionstruct.thicknesspath=find_option(options,'thicknesspath');
if isempty(optionstruct.thicknesspath),
	thicknesspath=[modeldatapath '/BedMap/gridded/thickness.mat'];
	if exist(thicknesspath),
		optionstruct.thicknesspath=thicknesspath;
	else
		optionstruct.thicknesspath='';
	end
end
disp(sprintf('   %-18s: %s','thicknesspath',optionstruct.thicknesspath));

%firnpath
optionstruct.firnpath=find_option(options,'firnpath');
if isempty(optionstruct.firnpath),
	firnpath=[modeldatapath '/BroekeFirn1km/firn.mat'];
	if exist(firnpath),
		optionstruct.firnpath=firnpath;
	else
		optionstruct.firnpath='';
	end
end
disp(sprintf('   %-18s: %s','firnpath',optionstruct.firnpath));

%surfacepath
optionstruct.surfacepath=find_option(options,'surfacepath');
if isempty(optionstruct.surfacepath),
	surfacepath=[modeldatapath '/BamberDEMAntarctica1km/surface_smooth30_lowslope.mat'];
	if exist(surfacepath),
		optionstruct.surfacepath=surfacepath;
	else
		optionstruct.surfacepath='';
	end
end
disp(sprintf('   %-18s: %s','surfacepath',optionstruct.surfacepath));

%mosaicpath
optionstruct.mosaicpath=find_option(options,'mosaicpath');
if isempty(optionstruct.mosaicpath),
	mosaicpath=[modeldatapath '/RignotAntarcticaVelMosaicRampErsAlos/RignotAntVel.mat'];
	if exist(mosaicpath),
		optionstruct.mosaicpath=mosaicpath;
	else
		optionstruct.mosaicpath='';
	end
end
disp(sprintf('   %-18s: %s','mosaicpath',optionstruct.mosaicpath));

%temperaturepath
optionstruct.temperaturepath=find_option(options,'temperaturepath');
if isempty(optionstruct.temperaturepath),
	temperaturepath=[modeldatapath '/GiovinettoZwallyTemperatures92/Giovinetto_Temperatures.mat'];
	if exist(temperaturepath),
		optionstruct.temperaturepath=temperaturepath;
	else
		optionstruct.temperaturepath='';
	end
end
disp(sprintf('   %-18s: %s','temperaturepath',optionstruct.temperaturepath));

%heatfluxpath
optionstruct.heatfluxpath=find_option(options,'heatfluxpath');
if isempty(optionstruct.heatfluxpath),
	heatfluxpath=[modeldatapath '/HeatfluxAntarctica/RignotHeatFlux.mat'];
	if exist(heatfluxpath),
		optionstruct.heatfluxpath=heatfluxpath;
	else
		optionstruct.heatfluxpath='';
	end
end
disp(sprintf('   %-18s: %s','heatfluxpath',optionstruct.heatfluxpath));

%numlayers
optionstruct.numlayers=find_option(options,'numlayers');
if isempty(optionstruct.numlayers),
	optionstruct.numlayers=0;
end
disp(sprintf('   %-18s: %g','numlayers',optionstruct.numlayers));

%extrusionexponent
optionstruct.extrusionexponent=find_option(options,'extrusionexponent');
if isempty(optionstruct.extrusionexponent),
	optionstruct.extrusionexponent=3;
end
disp(sprintf('   %-18s: %g','extrusionexponent',optionstruct.extrusionexponent));


%elementstype
optionstruct.elementstype=find_option(options,'elementstype');
if isempty(optionstruct.elementstype),
	if optionstruct.numlayers>0,
		optionstruct.elementstype='pattyn';
	else
		optionstruct.elementstype='macayeal';
	end
end
disp(sprintf('   %-18s: %s','elementstype',optionstruct.elementstype));

