function md=mesh2grid(md,field,cornereast,cornernorth,xspacing,yspacing,nlines,ncols,defautvalue)
%MESH2GRID - build a grid out of a filed given on the mesh
%
%   Usage:
%      md=mesh2grid(md,data,cornereast,cornernorth,xspacing,yspacing,nlines,ncols,defautvalue)

if strcmpi(md.type,'2d'),
	error('mesh2grid error message: 3d mesh not supported yet')
end

if ischar(field),
	md.mesh2grid_parameters{end+1}=field;
end

[md.mesh2grid_x_m md.mesh2grid_y_m md.mesh2grid_data]=...
	InterpFromMeshToGrid(md.elements,md.x,md.y,md.(field),cornereast,cornernorth,xspacing,yspacing,nlines,ncols,defautvalue);
