/*
 * UpdateElementsAndMaterialsControl:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	UpdateElementsAndMaterialsControl(Elements* elements,Parameters* parameters,Materials* materials, IoModel* iomodel){
	/*Intermediary*/
	bool       control_analysis;
	int        control,cost_function,domaintype;
	int        num_controls,num_cost_functions;
	Element   *element          = NULL;
	Material  *material         = NULL;
	int       *control_enums    = NULL;
	char     **controls         = NULL;
	char     **cost_functions   = NULL;

	/*Fetch parameters: */
	bool isautodiff;
	iomodel->FindConstant(&isautodiff,"md.autodiff.isautodiff");
	if(isautodiff){
		UpdateElementsAndMaterialsControlAD(elements,parameters,materials,iomodel);
		return;
	}

	/*Fetch parameters: */
	iomodel->FindConstant(&control_analysis,"md.inversion.iscontrol");
	if(control_analysis) iomodel->FindConstant(&num_controls,"md.inversion.num_control_parameters");

	/*Now, return if no control*/
	if(!control_analysis) return;

	/*Process controls and convert from string to enums*/
	iomodel->FindConstant(&controls,&num_controls,"md.inversion.control_parameters");
	if(num_controls<1) _error_("no controls found");
	control_enums=xNew<int>(num_controls);
	for(int i=0;i<num_controls;i++){
		control_enums[i]=StringToEnumx(controls[i]);
	}

	/*Process cost functions and convert from string to enums*/
	iomodel->FindConstant(&num_cost_functions,"md.inversion.num_cost_functions");
	iomodel->FindConstant(&cost_functions,&num_cost_functions,"md.inversion.cost_functions");
	if(num_cost_functions<1) _error_("No cost functions found");
	int* cost_function_enums=xNew<int>(num_cost_functions);
	for(int i=0;i<num_cost_functions;++i){
		cost_function_enums[i]=StringToEnumx(cost_functions[i]);
	}

	iomodel->FetchData(3,"md.inversion.cost_functions_coefficients","md.inversion.min_parameters","md.inversion.max_parameters");

	/*Fetch Observations */
	iomodel->FindConstant(&domaintype,"md.mesh.domain_type");
	for(int i=0;i<num_cost_functions;i++){
		cost_function=cost_function_enums[i];
		if(     cost_function==ThicknessAbsMisfitEnum) iomodel->FetchDataToInput(elements,"md.inversion.thickness_obs",InversionThicknessObsEnum);
		else if(cost_function==SurfaceAbsMisfitEnum)   iomodel->FetchDataToInput(elements,"md.inversion.surface_obs",InversionSurfaceObsEnum);
		else if(cost_function==SurfaceAbsVelMisfitEnum
			  || cost_function==SurfaceRelVelMisfitEnum
			  || cost_function==SurfaceLogVelMisfitEnum
			  || cost_function==SurfaceLogVxVyMisfitEnum
			  || cost_function==SurfaceAverageVelMisfitEnum){
			iomodel->FetchDataToInput(elements,"md.inversion.vx_obs",InversionVxObsEnum);
			if(domaintype!=Domain2DverticalEnum) iomodel->FetchDataToInput(elements,"md.inversion.vy_obs",InversionVyObsEnum); 
		}
	}
	parameters->AddObject(new IntParam(ControlInputSizeMEnum,iomodel->numberofvertices));

	for(int i=0;i<num_controls;i++){
		control = control_enums[i];
		switch(control){
			/*List of supported controls*/
			case BalancethicknessThickeningRateEnum:      iomodel->FetchData(1,"md.balancethickness.thickening_rate"); break;
			case BalancethicknessSpcthicknessEnum:        iomodel->FetchData(1,"md.balancethickness.spcthickness"); break;
			case VxEnum:                                  iomodel->FetchData(1,"md.initialization.vx"); break;
			case VyEnum:                                  iomodel->FetchData(1,"md.initialization.vy"); break;
			case ThicknessEnum:                           iomodel->FetchData(1,"md.geometry.thickness"); break;
			case FrictionCoefficientEnum:                 iomodel->FetchData(1,"md.friction.coefficient"); break;
			case FrictionAsEnum:                          iomodel->FetchData(1,"md.friction.As"); break;
			case BalancethicknessApparentMassbalanceEnum: iomodel->FetchData(1,"md.balancethickness.apparent_massbalance"); break;
			case BalancethicknessOmegaEnum:               iomodel->FetchData(1,"md.balancethickness.omega"); break;
			case MaterialsRheologyBEnum:                  iomodel->FetchData(1,"md.materials.rheology_B"); break;
			/*Special cases*/
			case MaterialsRheologyBbarEnum: iomodel->FetchData(1,"md.materials.rheology_B"); break;
			case DamageDbarEnum:            iomodel->FetchData(1,"md.damage.D");            break;
			default:
				_error_("Control " << EnumToStringx(control) << " not implemented yet");
		}
	}

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->InputUpdateFromIoModel(i,iomodel); //we need i to index into elements.
			counter++;
		}
	}

	/*Free data: */
	for(int i=0;i<num_controls;i++){
		switch(control_enums[i]){
			/*List of supported controls*/
			case BalancethicknessThickeningRateEnum:      iomodel->DeleteData(1,"md.balancethickness.thickening_rate"); break;
			case BalancethicknessSpcthicknessEnum:        iomodel->DeleteData(1,"md.balancethickness.spcthickness"); break;
			case VxEnum:                                  iomodel->DeleteData(1,"md.initialization.vx"); break;
			case VyEnum:                                  iomodel->DeleteData(1,"md.initialization.vy"); break;
			case ThicknessEnum:                           iomodel->DeleteData(1,"md.geometry.thickness"); break;
			case FrictionCoefficientEnum:                 iomodel->DeleteData(1,"md.friction.coefficient"); break;
			case FrictionAsEnum:                          iomodel->DeleteData(1,"md.friction.As"); break;
			case BalancethicknessApparentMassbalanceEnum: iomodel->DeleteData(1,"md.balancethickness.apparent_massbalance"); break;
			case BalancethicknessOmegaEnum:               iomodel->DeleteData(1,"md.balancethickness.omega"); break;
			case MaterialsRheologyBEnum:                  iomodel->DeleteData(1,"md.materials.rheology_B"); break;
			/*Special cases*/
			case MaterialsRheologyBbarEnum: iomodel->DeleteData(1,"md.materials.rheology_B"); break;
			case DamageDbarEnum:            iomodel->DeleteData(1,"md.damage.D");            break;
			default:
				_error_("Control " << EnumToStringx(control_enums[i]) << " not implemented yet");
		}
	}

	iomodel->DeleteData(3,"md.inversion.cost_functions_coefficients","md.inversion.min_parameters","md.inversion.max_parameters");
	xDelete<int>(control_enums);
	xDelete<int>(cost_function_enums);
	for(int i=0;i<num_cost_functions;i++) xDelete<char>(cost_functions[i]);
	xDelete<char*>(cost_functions);
	for(int i=0;i<num_controls;i++) xDelete<char>(controls[i]);
	xDelete<char*>(controls);
}
void UpdateElementsAndMaterialsControlAD(Elements* elements,Parameters* parameters,Materials* materials, IoModel* iomodel){

	#if defined(_HAVE_ADOLC_)
	/*Intermediaries*/
	int				num_independent_objects,M,N,M_par,N_par;
	char**			names                   = NULL;
	int*				types							= NULL;
	int*				control_sizes				= NULL;
	int*				M_all							= NULL;
	IssmDouble*		independent					= NULL;
	IssmDouble*		independents_fullmin    = NULL;
	IssmDouble*		independents_fullmax		= NULL;
	bool				control_analysis			=false;

	iomodel->FindConstant(&control_analysis,"md.inversion.iscontrol");

	/*Now, return if no control*/
	if(!control_analysis) return;

	/*Step1: create controls (independents)*/
	iomodel->FetchData(&num_independent_objects,"md.autodiff.num_independent_objects");
	_assert_(num_independent_objects>0); 
	iomodel->FetchData(&names,&M,"md.autodiff.independent_object_names");
	_assert_(M==num_independent_objects);
	iomodel->FetchData(&types,NULL,NULL,"md.autodiff.independent_object_types");

	M_all = xNew<int>(num_independent_objects);

	/*create independent objects, and at the same time, fetch the corresponding independent variables, 
	 *and declare them as such in ADOLC: */
	iomodel->FetchData(&independents_fullmin,&M_par,&N_par,"md.autodiff.independent_min_parameters");
	iomodel->FetchData(&independents_fullmax,&M_par,&N_par,"md.autodiff.independent_max_parameters");
	iomodel->FetchData(&control_sizes,NULL,NULL,"md.autodiff.independent_control_sizes");

	int* start_point = NULL;
	start_point = xNew<int>(num_independent_objects);
	int counter = 0;
	for(int i=0;i<num_independent_objects;i++){
		start_point[i]=counter; 
		counter+=control_sizes[i];
	}

	for(int i=0;i<num_independent_objects;i++){

		if(types[i]==1){ /* vector:*/

			/*Get field name and input Enum from independent name*/
			char* iofieldname  = NULL;
			int   input_enum;
			IssmDouble*  	independents_min			= NULL;
			IssmDouble*	   independents_max			= NULL;

			FieldAndEnumFromCode(&input_enum,&iofieldname,names[i]);

			/*Fetch required data*/
			iomodel->FetchData(&independent,&M,&N,iofieldname);
			_assert_(independent);
			_assert_(N==control_sizes[i]);

			independents_min = NULL; independents_min = xNew<IssmDouble>(M*N);
			independents_max = NULL; independents_max = xNew<IssmDouble>(M*N);
			for(int m=0;m<M;m++){
				for(int n=0;n<N;n++){
					independents_min[N*m+n]=independents_fullmin[N_par*m+start_point[i]+n];
					independents_max[N*m+n]=independents_fullmax[N_par*m+start_point[i]+n];
				}
			}
			if(N!=1) M_all[i]=M-1;
			else M_all[i]=M;

			for(int j=0;j<elements->Size();j++){
				Element* element=xDynamicCast<Element*>(elements->GetObjectByOffset(j));
				element->ControlInputCreate(independent,independents_min,independents_max,iomodel,M,N,input_enum,i+1);
			}
			xDelete<IssmDouble>(independent);
			xDelete<IssmDouble>(independents_min);
			xDelete<IssmDouble>(independents_max);

		}
		else{
			_error_("Independent cannot be of size " << types[i]);
		}
	}
	parameters->AddObject(new IntVecParam(ControlInputSizeNEnum,control_sizes,num_independent_objects));
	parameters->AddObject(new IntVecParam(ControlInputSizeMEnum,M_all,num_independent_objects));

	/*cleanup*/
	for(int i=0;i<num_independent_objects;i++){
		xDelete<char>(names[i]);
	}
	xDelete<char*>(names);
	xDelete<int>(types);
	xDelete<int>(M_all);
	xDelete<IssmDouble>(independents_fullmin);
	xDelete<IssmDouble>(independents_fullmax);
	xDelete<int>(start_point);
	/*Step2: create cost functions (dependents)*/

	return;
#else 
	_error_("ADOLC not compiled");
#endif
}
