/*\file ParameterOutput.c
 *\brief: build output vectors for parameter outputs (like strain rate, stress, penalty active sets, etc ...)
 */

#include "./ParameterOutput.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	ParameterInputs* inputs=NULL;
	DataSet* results=NULL;
	int               analysis_type;
	int               sub_analysis_type;
	
	/* output datasets: */
	Mat Kgg=NULL;
	Vec pg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ParameterOutputUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&results,NULL,NULL,RESULTS,"DataSet",NULL);
	
	/*parameters: */
	FetchData((void**)&analysis_type,NULL,NULL,ANALYSIS,"Integer",NULL);
	FetchData((void**)&sub_analysis_type,NULL,NULL,SUBANALYSIS,"Integer",NULL);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Generate internal degree of freedom numbers: */
	ParameterOutputx(results, elements,nodes,loads,materials,inputs,analysis_type,sub_analysis_type); 

	/*write output datasets: */
	WriteData(RESULTS,results,0,0,"DataSet",NULL); 
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete results;
	delete inputs;

	/*end module: */
	MODULEEND();
}

void ParameterOutputUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(eleemnts,nodes,loads,materials,params,inputs,analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
