/*\file SpcNodes.c
 *\brief: build degrees of freedom for every node.
 */

#include "./SpcNodes.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* nodes=NULL;
	DataSet* constraints=NULL;

	/* output datasets: */
	DofVec*         yg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SpcNodesUsage);

	/*Input datasets: */
	FetchData((void**)&nodes,NULL,NULL,NODESIN,"DataSet",NULL);
	FetchData((void**)&constraints,NULL,NULL,CONSTRAINTS,"DataSet",NULL);
	
	/*!Generate internal degree of freedom numbers: */
	SpcNodesx( &yg, nodes,constraints); 

	/*write output datasets: */
	WriteData(NODES,nodes);
	WriteData(YG,yg);

	/*Free ressources: */
	delete nodes;
	delete constraints;
	delete yg;

	/*end module: */
	MODULEEND();
}

void SpcNodesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [m.node,m.yg]=%s(m.nodes,m.constraints);\n",__FUNCT__);
	_printf_("\n");
}
