/*\file MpcNodes.c
 *\brief:  handle rigid body modes.
 */

#include "./MpcNodes.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* nodes=NULL;
	DataSet* constraints=NULL;

	/* output datasets: */
	Mat         Rmg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MpcNodesUsage);

	/*Input datasets: */
	FetchData((void**)&nodes,NULL,NULL,NODESIN,"DataSet",NULL);
	FetchData((void**)&constraints,NULL,NULL,CONSTRAINTS,"DataSet",NULL);

	/*!Generate internal degree of freedom numbers: */
	MpcNodesx( &Rmg, nodes,constraints); 
	
	/*write output datasets: */
	WriteData(RMG,Rmg);
	WriteData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete constraints;
	MatFree(&Rmg);

	/*end module: */
	MODULEEND();
}

void MpcNodesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: m.Rmg=%s(m.nodes,m.constraints);\n",__FUNCT__);
	_printf_("\n");
}
