/*\file FieldExtrude.c
 *\brief: extrude field vertically
 */

#include "./FieldExtrude.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Vec      field=NULL;
	char*    field_name=NULL;
	int      collapse=0;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&FieldExtrudeUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&field,NULL,NULL,FIELD,"Vector",NULL);
	FetchData((void**)&field_name,NULL,NULL,FIELDNAME,"String",NULL);
	FetchData((void**)&collapse,NULL,NULL,COLLAPSE,"Integer",NULL);

	/*!Call core code: */
	FieldExtrudex(field,elements,nodes,loads,materials,field_name,collapse);

	/*write output : */
	WriteData(FIELDOUT,field);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	VecFree(&field);
	xfree((void**)&field_name);
	
	/*end module: */
	MODULEEND();

}

void FieldExtrudeUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [field] = %s(elements, nodes,loads, materials, field, field_name, collapse);\n",__FUNCT__);
	_printf_("\n");
}
