/*\file FieldDepthAverage.c
 *\brief: average field throfieldh thickness
 */

#include "./FieldDepthAverage.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Vec      field=NULL;
	char*    fieldname=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&FieldDepthAverageUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&field,NULL,NULL,FIELD,"Vector",NULL);
	FetchData((void**)&fieldname,NULL,NULL,FIELDNAME,"String",NULL);

	/*!Call core code: */
	FieldDepthAveragex(field,elements,nodes,loads,materials,fieldname);

	/*write output : */
	WriteData(FIELDOUT,field);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	VecFree(&field);
	xfree((void**)&fieldname);
	
	/*end module: */
	MODULEEND();

}

void FieldDepthAverageUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [field] = %s(elements, nodes,loads, materials, field,fieldname);\n",__FUNCT__);
	_printf_("\n");
}
