/*\file ControlConstrain.c
 *\brief: constrain updated parameters during inverse control run
 */

#include "./ControlConstrain.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	double*  p_g=NULL;
	double   mincontrolconstraint;
	double   maxcontrolconstraint;
	char*    control_type=NULL;
	int      gsize;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlConstrainUsage);

	/*Input datasets: */
	FetchData((void**)&p_g,&gsize,NULL,PG,"Vector","Vec");
	FetchData((void**)&mincontrolconstraint,NULL,NULL,mxGetField(PARAMETERS,0,"mincontrolconstraint"),"Scalar",NULL);
	FetchData((void**)&maxcontrolconstraint,NULL,NULL,mxGetField(PARAMETERS,0,"maxcontrolconstraint"),"Scalar",NULL);
	FetchData((void**)&control_type,NULL,NULL,mxGetField(PARAMETERS,0,"control_type"),"String",NULL);

	/*!Call core code: */
	ControlConstrainx(p_g,gsize,mincontrolconstraint,maxcontrolconstraint,control_type);

	/*write output : */
	WriteData(PGOUT,p_g,gsize);

	/*Free ressources: */
	xfree((void**)&control_type);

	/*end module: */
	MODULEEND();
}

void ControlConstrainUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [p_g] = %s(p_g,parameters);\n",__FUNCT__);
	_printf_("\n");
}
