%-----------------------------------------------------------------------
%	CreateFEMModel.m: from a matlab ISSM @model class object, create a finite element 
%                  model structure, with "c" code datasets (elements, nodes, loads,  constraints, 
%                  parameters, partitioning vectors.
%
%-----------------------------------------------------------------------

function  m=CreateFEMModel(md)
	
	displaystring(md.debug,'\n   reading data from model %s...',md.name);
	[m.elements,m.nodes,m.constraints,m.loads,m.materials,parameters]=ModelProcessor(md);

	displaystring(md.debug,'%s','   generating degrees of freedom...');
	[m.nodes,m.part,m.tpart]=Dof(m.elements,m.nodes,parameters);

	displaystring(md.debug,'%s','   generating single point constraints...');
	[m.nodes,m.yg]=SpcNodes(m.nodes,m.constraints);

	displaystring(md.debug,'%s','   generating rigid body constraints...');
	[m.Rmg,m.nodes]=MpcNodes(m.nodes,m.constraints);

	displaystring(md.debug,'%s','   generating node sets...');
	m.nodesets=BuildNodeSets(m.nodes);

	displaystring(md.debug,'%s','   reducing single point constraints vector...');
	[m.ys m.ys0]=Reducevectorgtos(m.yg.vector,m.nodesets);
	
	displaystring(md.debug,'%s','   normalizing rigid body constraints matrix...');
	m.Gmn = NormalizeConstraints(m.Rmg,m.nodesets);

	displaystring(md.debug,'%s','   configuring element and loads...');
	[m.elements,m.loads,m.nodes] = ConfigureObjects( m.elements, m.loads, m.nodes, m.materials);

	displaystring(md.debug,'%s','   processing parameters...');
	parameters= ProcessParams(parameters,m.part.vector);

	displaystring(md.debug,'%s','   creating parameters in matlab workspace...');
	m.parameters= ParamsToWorkspace(parameters);

	%Get rid of parameters dataset. 
	clear parameters;

end
