/*\file io.h
 *\brief: I/O for ISSM
 */

#ifndef IO_H_
#define IO_H_

#include "../objects/NodeSets.h"
#include "../objects/DofVec.h"
#include "../DataSet/DataSet.h"
#include "../include/types.h"

class DataSet;

void FetchData(void** pdata,int* pM,int* pN,ConstDataHandle data_handle,char* data_type,char* sub_data_type);
void IoModelFetchData(void** pdata,int* pM,int* pN,ConstDataHandle model_handle,char* data_name,char* data_type,char* sub_data_type);

/*Serial: */
#ifdef _SERIAL_
/*Write: */
void WriteData(mxArray** pdataref,DataSet* dataset);
void WriteData(mxArray** pdataref,Mat matrix);
void WriteData(mxArray** pdataref,double* matrix, int M,int N);
void WriteData(mxArray** pdataref,Vec vector);
void WriteData(mxArray** pdataref,double* vector, int M);
void WriteData(mxArray** pdataref,int integer);
void WriteData(mxArray** pdataref,double scalar);
void WriteData(mxArray** pdataref,char* string);
void WriteData(mxArray** pdataref,DofVec* vector);
void WriteNodeSets(DataHandle* pdataref,NodeSets* nodesets);
void WriteParams(DataHandle* pdataref,DataSet* parameters);

/*Fetch: */
void SerialFetchData(void** pdata,int* pM,int* pN,ConstDataHandle data_handle,char* data_type,char* sub_data_type);
void FetchNodeSets(NodeSets** pnodesets,ConstDataHandle dataref);
#endif

/*Parallel: */
#ifdef _PARALLEL_
void ParallelFetchData(void** pdata,int* pM,int* pN,DataHandle data_handle, char* data_type,char* sub_data_type);
void ParallelFetchMat(double** pdata,int* pM,int* pN,DataHandle data_handle);
void ParallelFetchString(char** pdata,DataHandle data_handle);
void ParallelFetchScalar(double* pdata,DataHandle data_handle);
void ParallelFetchInteger(int* pdata,DataHandle data_handle);
void WriteDataToDisk(void* data,int* pM,int* pN,char* datatype,FILE* fid);
void WriteData(int* pdummy,void* data,char* data_type);
#endif

/*File I/O: */
FILE* pfopen(char* filename,char* format);
void  pfclose(FILE* fid,char* filename);

#endif	/* _IMDB_H */

