/*\file Reduceloadfromgtof.c
 *\brief: reduce load from g set to f set
 */

#include "./Reduceloadfromgtof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Vec pg=NULL;
	Mat Gmn=NULL;
	Mat Kfs=NULL;
	Vec ys=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Vec pf=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReduceloadfromgtofUsage);

	/*Input datasets: */
	FetchData((void**)&pg,NULL,NULL,PG,"Vector",NULL);
	FetchData((void**)&Gmn,NULL,NULL,GMN,"Matrix",NULL);
	FetchData((void**)&Kfs,NULL,NULL,KFS,"Matrix",NULL);
	FetchData((void**)&ys,NULL,NULL,YS,"Vector",NULL);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce load from g to f size: */
	Reduceloadfromgtofx(&pf, pg, Gmn, Kfs, ys, nodesets);

	/*write output datasets: */
	WriteData(PF,pf);

	/*Free ressources: */
	VecFree(&pg);
	MatFree(&Gmn);
	MatFree(&Kfs);
	VecFree(&ys);
	delete nodesets;

	/*end module: */
	MODULEEND();
}

void ReduceloadfromgtofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [pf] = %s(pg,Gmn,Kfs,ys,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
