/*\file MassFlux.c
 *\brief: compute mass flux along a profile.
 */

#include "./MassFlux.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	double*  segments=NULL;
	int      num_segments;
	double*  ug=NULL;
	mxArray* pfield=NULL;

	/* output datasets: */
	double   mass_flux;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MassFluxUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);

	/*parameters: */
	FetchData((void**)&segments,&num_segments,NULL,mxGetField(PARAMETERS,0,"qmu_mass_flux_segments"),"Matrix","Mat");

	/*results: */
	FetchData((void**)&ug,NULL,NULL,UG,"Matrix","Mat");

	/*!Compute mass flux along the profile: */
	MassFluxx(&mass_flux, elements,nodes,loads,materials,segments,num_segments,ug);

	/*write output datasets: */
	WriteData(RESPONSE,mass_flux);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	xfree((void**)&ug);

	/*end module: */
	MODULEEND();
}

void MassFluxUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(eleemnts,nodes,loads,materials,params,inputs,analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
