/*! \file  ContourtoNodes
    \brief: takes a  contour file, and figures out which nodes  (x,y list)
    are inside this contour. 

	usage:
	[flags]=ContourToNodes(x,y,contours,interptype,edgevalue);
	
	where:

	input:

		x,y: node cooredinates
		
		contours: structure holding sets of vertices making open contours. 
		
		interptype: string definining type of interpolation ('element', or 'node', or 'element and node');

		edgevalue: integer (0, 1 or 2) defining the value associated to the nodes on the edges of the polygons

	output:
		flags: vector of flags (0 or 1), of size nods 
*/
	
#include "./ContourToNodes.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]) {

	int i,j;

	/* required input: */
	double* x=NULL;
	double* y=NULL;
	int     edgevalue;

	/* output: */
	Vec  flags=NULL;
	int  nods;

	//contours
	int numcontours;
	Contour** contours=NULL;
	Contour*  contouri=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	//CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ContourToNodesUsage); Cant' use it here, as we have variable  outputs.
	if((nlhs==0) && (nrhs=0)){
		ContourToNodesUsage();
		throw ErrorException(__FUNCT__," usage. See above");
	}

	/*Fetch inputs: */
	FetchData((void**)&x,&nods,NULL,XHANDLE,"Matrix","Mat");
	FetchData((void**)&y,NULL,NULL,YHANDLE,"Matrix","Mat");
	FetchData((void**)&edgevalue,NULL,NULL,EDGEVALUEHANDLE,"Integer",NULL);

	/*Recover list of contours from the 'contours' structure: */
	//number of contours;
	numcontours=mxGetNumberOfElements(CONTOURSHANDLE);
	//allocate array:
	contours=(Contour**)xmalloc(numcontours*sizeof(Contour*));

	//go through contours, and populate xcontours and ycontours accordingly.
	for(i=0;i<numcontours;i++){
		//allocate
		contouri=(Contour*)xmalloc(sizeof(Contour));
		//retrieve dimension of this contour.
		contouri->nods=(int)mxGetScalar(mxGetField(CONTOURSHANDLE,i,"nods"));
		//set pointers.
		contouri->x=mxGetPr(mxGetField(CONTOURSHANDLE,i,"x"));
		contouri->y=mxGetPr(mxGetField(CONTOURSHANDLE,i,"y"));
		*(contours+i)=contouri;
	}

	#ifdef _ISSM_DEBUG_
	for(i=0;i<numcontours;i++){
		printf("\nContour echo: contour number  %i / %i\n",i+1,numcontours);
		contouri=*(contours+i);
		printf("   Number of grids %i\n",contouri->nods);
		for (j=0;j<contouri->nods;j++){
			printf("   %lf %lf\n",*(contouri->x+j),*(contouri->y+j));
		}
	}
	#endif

	/*Run interpolation routine: */
	ContourToNodesx( &flags,x,y,nods,contours,numcontours,edgevalue);

	/* output: */
	WriteData(FLAGS,flags);

	/*end module: */
	MODULEEND();
	
}

void ContourToNodesUsage(void)
{
	printf("   usage:\n");
	printf("   [flags]=ContourToNodes(,x,y,contours,edgevalue);\n\n");
	printf("   where:\n");
	printf("      x,y: list of nodes.\n");
	printf("      contours: structure holding sets of vertices making open contours.\n");
	printf("      interptype: string definining type of interpolation ('element', or 'node').\n");
	printf("      edgevalue: integer (0, 1 or 2) defining the value associated to the nodes on the edges of the polygons.\n");
	printf("      flags: vector of flags (0 or 1), of size nods.\n");
	printf("\n");
}
