/*!\file SpcNodesx
 * \brief: establish single point constraints on all grids, as well as constraints vector.
 */

#include "./SpcNodesx.h"

#undef __FUNCT__ 
#define __FUNCT__ "SpcNodesx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void SpcNodesx( DofVec** pyg, DataSet* nodes,DataSet* constraints){

	int i;
	int numberofdofs;
	int gsize;

	/*output: */
	DofVec* yg=NULL;

	/*First, recover number of dofs from nodes: */
	numberofdofs=nodes->NumberOfDofs();

	if(numberofdofs){
		
		/*Allocate dofvec: */
		yg=new DofVec("yg");
		yg->numdofs=numberofdofs;

		/*Allocate yg: */
		yg->vector=NewVec(numberofdofs);

		/*Now, go through constraints, and update the nodes and the constraint vector at the same time: */
		constraints->SetupSpcs(nodes,yg->vector);

		/*Specify numentries: */
		VecGetSize(yg->vector,&gsize);
		yg->numentries=(int)gsize/yg->numdofs;
	}
	else{
		/*Allocate dofvec: */
		yg=new DofVec("yg");
	}

	/*Assign output pointers: */
	*pyg=yg;
}
