function object = dofvec(varargin)
%ICEFRONT - constructor for dofvec object
%
%   Usage:
%      dofvec = dofvec(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	object.name='';
	object.numdof=1;
	object.numentries=0;
	object.vector=zeros(0,1);
	object=class(object,'dofvec');
case 1
	%If single argument of class dofvec, we have a copy constructor. 
	if (isa(varargin{1},'dofvec'))
		object = varargin{1};
	elseif ischar(varargin{1}),
		object= dofvec;
		object.name=varargin{1};
	else 
		error('dofvec constructor error message: unknown type of constructor call');
	end 
otherwise
	error('dofvec constructor error message: unknown type of constructor call');
end
