%Test Name: SquareShelfStressSSA2d
if 0
md=triangle(model(),'../Exp/Square.exp',10000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',5);
md=solve(md,'Stressbalance');
else
	clf
	md=bamg(model(),'domain','../Exp/Square.exp','hmax',10000.);
	newdomain = '../Exp/Square_temp.exp';
	resolution = 10000;
	distance=abs(ExpToLevelSet(md.mesh.x,md.mesh.y,newdomain));
	pos=find(ContourToNodes(md.mesh.x,md.mesh.y,newdomain,2));
	distance(pos) = -distance(pos);
	pos=find(distance<-resolution);
	%md2=bamg(model(),'domain','../Exp/Square_temp.exp','hmax',10000.,'RequiredVertices',[md.mesh.x(pos) md.mesh.y(pos) pos],'hmin',10000);
	md2=bamg(model(),'domain','../Exp/Square_temp.exp','RequiredVertices',[md.mesh.x(pos) md.mesh.y(pos) pos],'hmax',resolution);
	patch( 'Faces',[md.mesh.elements], 'Vertices', [md.mesh.x md.mesh.y],'FaceVertexCData',zeros(size(md.mesh.x)),'FaceColor','none','EdgeColor','k');
	hold on
	patch( 'Faces',[md2.mesh.elements], 'Vertices', [md2.mesh.x md2.mesh.y],'FaceVertexCData',zeros(size(md2.mesh.x)),'FaceColor','none','EdgeColor','r');
	error('S');
	%md=bamg(model(),'domain','../Exp/Square_temp2.exp','hmax',10000.);
	md=setmask(md,'all','');
	md=parameterize(md,'../Par/SquareShelf.par');
	md=setflowequation(md,'SSA','all');
	pos = find((md.mesh.x>10 & md.mesh.x<max(md.mesh.x)-10) & md.mesh.y>10);
	md.stressbalance.spcvx(pos)=NaN;
	md.stressbalance.spcvy(pos)=NaN;
	pos = find(md.mesh.vertexonboundary);
	md.mask.ice_levelset(pos)=0;
	%pos = find(md.mesh.y>10);
	%md.stressbalance.spcvy(pos)=NaN;
	md.cluster=generic('name',oshostname(),'np',5);
	md=solve(md,'Stressbalance');

	%Compute vm stress
	md=mechanicalproperties(md,md.results.StressbalanceSolution.Vx,md.results.StressbalanceSolution.Vy);
	lambda1 = max(md.results.strainrate.principalvalue1,0.);
	lambda2 = max(md.results.strainrate.principalvalue2,0.);
	epse_2    = 1./2. *(lambda1.*lambda1 + lambda2.*lambda2);
	n=3;
	vm=sqrt(3.) * md.materials.rheology_B(1).* epse_2.^(1./(2.*n));

end

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure'};
field_tolerances={1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.StressbalanceSolution.Vx),...
	(md.results.StressbalanceSolution.Vy),...
	(md.results.StressbalanceSolution.Vel),...
	(md.results.StressbalanceSolution.Pressure),...
	};
