#move this stuff elsewhere
from helpers import *

from dakota_in_write import *
from dakota_in_params import *
from MatlabFuncs import *

def dakota_in_data(dmeth,variables,responses,dparams,filei,*args):
	'''
  define the data to write the dakota .in and .m files.

  []=dakota_in_data(dmeth,variables,responses,dparams,filei,*args)

  where the required input is:
    dmeth         (dakota_method, method class object)
    variables     (structure array, variable class objects)
    responses     (structure array, response class objects)
    dparams       (structure array, method-independent parameters)
    filei         (character, name of .in and .m files)

  params may be empty, in which case defaults will be used.

  the optional args are passed directly through to the
  QmuUpdateFunctions brancher to be used by the analysis
  package.  for example, this could be model information.

  this function defines the data to write the dakota .in and
  .m files.  it is necessary for multiple reasons.  first,
  it collects the parameters and applies some defaults that
  are unique to the environment.  second, some analysis package
  variables and/or responses may be treated differently by
  dakota.  for example, an analysis package variable may be
  defined as an array, so the QmuSetupDesign brancher will
  create dakota variables for each element of the array.
  finally it calls the functions to write the .in and .m files.
  this function is independent of the particular analysis
  package.

  this data would typically be generated by a matlab script
  for a specific model, using the method, variable, and
  response class objects.
'''

	##  parameters
	#  get default set of parameters
	params=dakota_in_params(struct())

	#  merge specified parameters into default set, whether or not
	#  they already exist
	fnames=fieldnames(dparams)

	for i in range(np.size(fnames)):
		if not isfield(params,fnames[i]):
			print 'WARNING: dakota_in_data:unknown_param: No parameter '+str(fnames[i])+' in default parameter set.'	
			
	    	exec('params.%s = vars(dparams)[fnames[i]]')%(fnames[i])

	# use matlab even though we are running python
	if params.direct and params.analysis_driver == '':
		params.analysis_driver='matlab'

	if strcmpi(params.analysis_driver,'matlab') and params.analysis_components == '':
		[pathstr,name,ext] = fileparts(filei)
		params.analysis_components=fullfile(pathstr,name+'.py')

	#  merge method parameters, though they shouldn't be in dparams
	# dmeth=dmeth_params_merge(dmeth,dparams)

	##  variables
	fnames=fieldnames(variables)

	# works like matlab arbitrary structs/classes, remembers order of input attributes
	dvar = OrderedStruct()
	dresp = OrderedStruct()

	for i in range(len(fnames)):
		# currently all variable types can just be copied
		exec('dvar.%s = vars(variables)[fnames[i]]')%(fnames[i])

	##  responses
	fnames=fieldnames(responses)

	for i in range(len(fnames)):
		#  currently all response types can just be copied
		exec('dresp.%s = vars(responses)[fnames[i]]')%(fnames[i])


	##  write files
	#Write in file
	dakota_in_write(dmeth,dvar,dresp,params,filei,*args)
