function applyoptions(md, data, options, canvas){ //{{{
	//APPLYOPTIONS - apply colobar, text, cloud, and expdisp options to current plot
	//
	//   Usage:
	//      applyoptions(md, data, options)
	//
	//   See also: PLOTMODEL, PARSE_OPTIONS

	//{{{ colorbar
	var gl = canvas.gl;
	if (options.exist('colorbar')) {
		if (options.getfieldvalue('colorbar')==1) {
			//{{{ Variable options initialization
			var caxis = options.getfieldvalue('caxis');
			var ccanvasid, ctitleid, clabelsid, ccanvas, ctitle, clabels, ccontext, cmap, colorbar, cwidth, cheight, cgradient, color, y, x;
			//}}}
			//{{{ Create colorbar labels
			var labels = [];
			var cdivisions = options.getfieldvalue('colorbarnticks', 6);
			var caxisdelta = caxis[1] - caxis[0];
			var precision = options.getfieldvalue('colorbarprecision', 3);
			var format = options.getfieldvalue('colorbarformat', 'f').toLowerCase();
			if (options.getfieldvalue('log','off')!='off') {
				for (var i=cdivisions; i >= 0; i--) {
					var scale = (Math.log10(caxis[1])-Math.log10(caxis[0]))/Math.log10(options.getfieldvalue('log', 10));
					if (format === 'f') {
						labels[i] = (Math.pow(options.getfieldvalue('log', 10), Math.log10(caxis[0])/Math.log10(options.getfieldvalue('log', 10))+scale*(cdivisions-i)/cdivisions)).toFixed(precision);
					}
					else if (format === 'e') {
						labels[i] = (Math.pow(options.getfieldvalue('log', 10), Math.log10(caxis[0])/Math.log10(options.getfieldvalue('log', 10))+scale*(cdivisions-i)/cdivisions)).toPrecision(precision);
					}
					else {
						labels[i] = (Math.pow(options.getfieldvalue('log', 10), Math.log10(caxis[0])/Math.log10(options.getfieldvalue('log', 10))+scale*(cdivisions-i)/cdivisions)).toFixed(precision);
					}
				}
			} else {
				for (var i=cdivisions; i >= 0; i--) {
					if (format === 'f') {
						labels[i] = (caxisdelta*(cdivisions-i)/cdivisions+caxis[0]).toFixed(precision);
					}
					else if (format === 'e') {
						labels[i] = (caxisdelta*(cdivisions-i)/cdivisions+caxis[0]).toPrecision(precision);
					}
					else {
						labels[i] = (caxisdelta*(cdivisions-i)/cdivisions+caxis[0]).toFixed(precision);
					}
				}
			} //}}}
			//{{{ Initialize colorbar canvas
			let colorbarSlug = options.getfieldvalue('colorbarSlug', options.getfieldvalue('canvasid') + '-colorbar');
			ccanvasid = colorbarSlug + '-canvas';
			ccanvas = $('#'+ccanvasid)[0];
			cwidth = ccanvas.width*options.getfieldvalue('colorbarwidth', 1);
			cheight = ccanvas.height*options.getfieldvalue('colorbarheight', 1);
			ccontext = ccanvas.getContext('2d');
			ccontext.clearRect(0, 0, cwidth, cheight);
			ccontext.beginPath();
			cmap = options.getfieldvalue('colormap','jet');
			colorbar = colorbars[cmap];
			cgradient = ccontext.createLinearGradient(0, 0, 0, cheight);
			//}}}
			//{{{ Draw colorbar gradient
			var position;
			var offset = 1 / (colorbar.length - 1) / 2;
			var scaling = 1 - 2 * offset;
			for (var i=0; i < colorbar.length; i++) {
				color = colorbar[colorbar.length-i-1];
				color = [Math.round(color[0]*255), Math.round(color[1]*255), Math.round(color[2]*255)];
				position = (i / (colorbar.length - 1) * scaling) + offset;
				cgradient.addColorStop(position, 'rgba(' + color.toString() + ', 1.0)');
			}
			ccontext.fillStyle=cgradient;
			ccontext.fillRect(0, 0, cwidth, cheight);
			//}}}
			//{{{ Draw colorbar border
			ccontext.beginPath();
			ccontext.lineWidth='1';
			ccontext.strokeStyle=options.getfieldvalue('colorbarfontcolor','black');
			ccontext.rect(0, 0, cwidth, cheight);
			ccontext.stroke();
			//}}}
			//{{{ Draw colorbar labels
			clabelsid = colorbarSlug + '-labels';
			clabels = $('#'+clabelsid);
			var clabelstring = '';
			clabels.empty();
			for (var i=0; i <= cdivisions; i++) {
				y = (i+0.5)/(cdivisions+1)*cheight;
				x = 0.2*cwidth;
				clabelstring += '<li><span>'+labels[i]+'</span></li>';
				ccontext.beginPath();
				ccontext.moveTo(0, y);
				ccontext.lineTo(x, y);
				ccontext.moveTo(cwidth-x, y);
				ccontext.lineTo(cwidth, y);
				ccontext.stroke();
			}
			clabels.append(clabelstring);
			//}}}
			//{{{ Draw colorbar title
			ctitleid = colorbarSlug + '-heading';
			ctitle = $('#'+ctitleid);
			if (options.exist('colorbarHeader')) { ctitle.html(options.getfieldvalue('colorbarHeader')); }
			//}}}
		}
	} //}}}
	//{{{ texture canvas
	var tcontext, tcanvas, tcanvasid, tURL, tgradient;
	tcanvasid = 'texturecanvas';
	var tcanvas = document.getElementById(tcanvasid);
	if (tcanvas == null) {
		$('<canvas id="texturecanvas" width="256" height="256" style="display: none;"></canvas>').insertAfter('#'+String(options.getfieldvalue('canvasid')));
		tcanvas = document.getElementById(tcanvasid);
	}
	tcontext = tcanvas.getContext('2d');
	tgradient = tcontext.createLinearGradient(0, 0, 0, 256);

	var cmap = options.getfieldvalue('colormap','jet');
	var colorbar = colorbars[cmap];
	for (var i = 0; i < colorbar.length; i++) {
		color = colorbar[colorbar.length - i - 1];
		color = [Math.round(color[0] * 255), Math.round(color[1] * 255), Math.round(color[2] * 255)];
		tgradient.addColorStop(i / (colorbar.length - 1), 'rgba(' + color.toString() + ', 1.0)');
	}
	tcontext.fillStyle = tgradient;
	tcontext.fillRect(0, 0, 256, 256);

	//Allow for special texture colors, drawing each color in equal width vertical rectangles. The last rectanglar section is reserved for the colormap.
	if (options.exist('maskregion')) {
		var maskObject = options.getfieldvalue('maskregion',{'enabled':false});
		if (maskObject.enabled && !vesl.helpers.isEmptyOrUndefined(maskObject.colors)) {
			var x = 0;
			var sections = Object.keys(maskObject.colors).length + 1;
			var size = 256;
			var width = Math.floor(1 / sections * size);
			for (var color in maskObject.colors) {
				tcontext.fillStyle = maskObject.colors[color];
				tcontext.fillRect(x++ * width, 0, width, size);
			}
		}
	}

	tURL = tcanvas.toDataURL();
	if (options.getfieldvalue('clf','on')=='off') {
		canvas.nodes['unit' + (Object.keys(canvas.nodes).length - 1)].texture = initTexture(canvas.gl, tURL);
	} else {
		canvas.nodes.unit.texture = initTexture(canvas.gl, tURL);
	}
	//}}}
	//{{{ text display
	var ctx;
	var overlaycanvasid;
	var overlaycanvas;
	//Only intialize overlay canvas once by checking if it's already been defined
	if (vesl.helpers.isEmptyOrUndefined(canvas.overlaycanvas)) {
		//Get drawing context and save reference on main WebGL canvas
		overlaycanvasid = options.getfieldvalue('overlayid', options.getfieldvalue('canvasid') + '-overlay')
		overlaycanvas = $('#' + overlaycanvasid)[0];
		ctx = overlaycanvas.getContext('2d');
		canvas.overlaycanvas = overlaycanvas;
	}
	overlaycanvas = canvas.overlaycanvas;
	ctx = overlaycanvas.getContext('2d');

	if (options.exist('textlabels')) {//{{{
		//Attatch new overlay handler to display text labels
		var textLabels = options.getfieldvalue('textlabels',[]);
		canvas.overlayHandlers['text'] = function(canvas) {
			for (var i = 0; i < textLabels.length; i++) {
				//Get text label to display
				var textLabel = textLabels[i];
				textLabel = {
					position: defaultFor(textLabel.position, vec3.create()),
					text: defaultFor(textLabel.text, ''),
					fontSize: defaultFor(textLabel.fontSize, 18),
					fontColor: defaultFor(textLabel.fontColor, 'black'),

				};

				// function declared in slr-gfm sim-front-end-controller.js
				// if labels are behind the globe sphere then skip iteartion and do not display them
				if (vesl.ui.isLabelVisible(textLabel)) {
					//Transform from world space to viewport space
					var screenPoint = vec3.transformMat4(vec3.create(), textLabel.position, canvas.camera.vpMatrix);
					var x = (screenPoint[0] + 1.0) * (canvas.width / 2) + canvas.selector.offset().left;
					var y = (-screenPoint[1] + 1.0) * (canvas.height / 2) + canvas.selector.offset().top;

					//Draw text
					ctx.font = 'bold ' + String(textLabel.fontSize) + 'px Arial Black, sans-serif';
					ctx.fillStyle = textLabel.fontColor;
					ctx.strokeStyle = 'white';
					ctx.textAlign = 'center';
					ctx.textBaseline = 'middle';
					ctx.fillText(textLabel.text, x, y);
					ctx.strokeText(textLabel.text, x, y);
				}
			}
		}
	}//}}}

	//{{{ additional rendering nodes
	if (options.exist('render')) {
		var meshresults = processmesh(md, data, options);
		var x = meshresults[0];
		var y = meshresults[1];
		var z = meshresults[2];
		var elements = meshresults[3];
		var is2d = meshresults[4];
		var isplanet = meshresults[5];

		var xlim = options.getfieldvalue('xlim', [ArrayMin(x), ArrayMax(x)]);
		var ylim = options.getfieldvalue('ylim', [ArrayMin(y), ArrayMax(y)]);
		var zlim = options.getfieldvalue('zlim', [ArrayMin(z), ArrayMax(z)]);

		var global = vec3.length([(xlim[0] + xlim[1]) / 2, (ylim[0] + ylim[1]) / 2, (zlim[0] + zlim[1]) / 2]) < 6371000/10; //tolerance for global models = center is 637100 meters away from center of earth
		var translation = global ? [(xlim[0] + xlim[1]) / 2, (ylim[0] + ylim[1]) / 2, (zlim[0] + zlim[1]) / 2] : canvas.view.position;

		var renderObjects = options.getfieldvalue('render',{});

		for (var renderObject in renderObjects) {
			//Modify renderObejct?
			var object = renderObjects[renderObject];
			object = {
				enabled: defaultFor(object.enabled, true),					//Toggle display of the render object node
				scale: defaultFor(object.scale, 1),							//Model matrix scaling
				x: defaultFor(object.x, [0.0, 1.0, 0.0, 0.0, 0.0, 0.0]),	//x coordinate array
				y: defaultFor(object.y, [0.0, 0.0, 0.0, 1.0, 0.0, 0.0]),	//y coordinate array
				z: defaultFor(object.z, [0.0, 0.0, 0.0, 0.0, 0.0, 1.0]),	//z coordinate array
				indices: defaultFor(object.indices, []),					//indices array
				name: defaultFor(object.name, 'NY'),						//Text to display for cities.
				size: defaultFor(object.size, 1),							//Physical size of the object in meters
				color: defaultFor(object.color, 'black'),					//Diffuse color of object
				height: defaultFor(object.height, 25000),					//Height of object along y axis, currently for clouds only
				range: defaultFor(object.range, 120000),					//Range of sz plane to spawn object, currently for clouds only
				quantity: defaultFor(object.quantity, 15),					//Quantity of objects to display, currently for clouds only
				source: defaultFor(object.source, 'NY'),					//Quantity of objects to display, currently for clouds only
				targets: defaultFor(object.targets, ['NY'])					//Quantity of objects to display, currently for clouds only
			};
			if (!object.enabled) { continue; }
			if ('sky' === renderObject && !('sky' in canvas.nodes)) {
				var mesh = GL.Mesh.icosahedron({size: 6371000 * canvas.atmosphere.scaleHeight, subdivisions: 5});
				var texture = initTexture(gl, canvas.assetsPath + '/textures/TychoSkymapII_t4_2k.jpg');
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'sky',
					'shaderName', 'SkyFromSpace',
					'cullFace', gl.FRONT,
					'mesh', mesh,
					'texture',texture,
					'translation',translation
				);
			}
			if ('space' === renderObject && !('space' in canvas.nodes)) {
				var mesh = GL.Mesh.sphere({size: 6371000 * 20});
				var texture = initTexture(gl, canvas.assetsPath + '/textures/TychoSkymapII_t4_2k.jpg');
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'space',
					'shaderName', 'Textured',
					'cullFace', gl.FRONT,
					'drawOrder', 2,
					'mesh', mesh,
					'texture',texture,
					'translation',translation
				);
			}
			if ('coastlines' === renderObject) {
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'coastlines',
					'shaderName', 'Colored',
					'drawMode', gl.LINE_STRIP,
					'lineWidth', options.getfieldvalue('linewidth', 1),
					'scale', [object.scale, object.scale, object.scale],
					'rotation', [-90, 0, 0]
				);
				node.patch('Vertices', [object.x, object.y, object.z], 'FaceColor', 'none');
			}
			if ('graticule' === renderObject && !('graticule' in canvas.nodes)) {
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'graticule',
					'shaderName', 'Colored',
					'drawMode', gl.LINE_STRIP,
					'lineWidth', options.getfieldvalue('linewidth', 1),
					'scale', [object.scale, object.scale, object.scale],
					'rotation', [-90, 180, 0]
				);
				node.patch('Vertices', [object.x, object.y, object.z], 'FaceColor', 'none');
			}
			if ('cities' === renderObject && !('cities' in canvas.nodes)) {
				var mesh = GL.Mesh.icosahedron({size: object.size, subdivisions: 1});
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'cities',
					'shaderName', 'ColoredDiffuse',
					'diffuseColor', object.color,
					'lineWidth', options.getfieldvalue('linewidth', 1),
					'scale', [object.scale, object.scale, object.scale],
					'rotation', [-90, 0, 0]
				);
				node.geometryShader('Mesh', mesh, 'Vertices', [object.x, object.y, object.z], 'Indices', object.indices);
			}
			if ('axis' === renderObject && !('axis' in canvas.nodes)) {
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'axis',
					'shaderName', 'Colored',
					'drawMode', gl.LINES,
					'diffuseColor', [1.0, 0.0, 0.0, 1.0],
					'lineWidth', options.getfieldvalue('linewidth', 1),
					'scale', [object.scale, object.scale, object.scale],
					'rotation', [0, 0, 0]
				);
				node.patch('Vertices', [object.x, object.y, object.z], 'FaceColor', 'none');
			}
			if ('city' === renderObject && !vesl.helpers.isEmptyOrUndefined(overlaycanvas)) {
				//city
				var mesh = GL.Mesh.sphere({size: object.size});
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'city',
					'shaderName', 'ColoredDiffuse',
					'diffuseColor', object.color,
					'mesh', mesh,
					'translation', [object.x, object.z, -object.y]
				);
				//Attatch new overlay handler to display city name
				canvas.overlayHandlers['city'] = function(canvas) {
					var node = canvas.nodes['city'];
					var object = node.renderObject;
					var screenPoint = vec3.transformMat4(vec3.create(), node.translation, canvas.camera.vpMatrix);
					var x = (screenPoint[0] + 1.0) * (canvas.width / 2) + canvas.selector.offset().left;
					var y = (-screenPoint[1] + 1.0) * (canvas.height / 2) + canvas.selector.offset().top;

					ctx.font = 'bold ' + String(options.getfieldvalue('colorbarfontsize', 22))+'px Arial Black, sans-serif';
					ctx.fillStyle = options.getfieldvalue('colorbarfontcolor','black');
					ctx.strokeStyle = 'white';
					ctx.textAlign = 'center';
					ctx.textBaseline = 'middle';
					ctx.fillText(object.name, x, y);
					ctx.strokeText(object.name, x, y);
				}
			}
			if ('clouds' === renderObject && !('clouds0' in canvas.nodes)) {
				//clouds
				var mesh = GL.Mesh.fromURL(canvas.assetsPath + '/obj/cloud.obj');
				for (var i = 0; i < object.quantity; i++) {
					//TODO: More options, less magic numbers. Add animation. Better shading.
					var offset = [randomizeAxis(translation[0], object.range),
												randomizeCloudHeight(translation[1], object),
												randomizeAxis(translation[2], object.range)];
					var randomSize = randomizeCloudSize(object.scale);
					var randomColor = randomizeCloudColor();
					node = new Node(
						'canvas', canvas,
						'options', options,
						'renderObject', object,
						'name', 'clouds' + i,
						'shaderName', 'ColoredDiffuse',
						'diffuseColor', [randomColor, randomColor, randomColor, 1.0],
						'specularColor', [0.1, 0.1, 0.1, 1.0],
						'mesh', mesh,
						'scale', [randomSize, randomSize, randomSize],
						'translation', offset
					);
				}
			}
			if ('citylines' === renderObject) {
				//city
				node = new Node(
					'canvas', canvas,
					'options', options,
					'renderObject', object,
					'name', 'citylines',
					'shaderName', 'ColoredDiffuse',
					'drawMode', gl.LINES,
					'diffuseColor', object.color,
					'lineWidth', options.getfieldvalue('linewidth', 1),
					'scale', [object.scale, object.scale, object.scale],
					'rotation', [0, 0, 0]
				);

				//For each target city, calculate the shortest line across the earth by performing a quaternion slerp.
				//Treat source and target city as vectors to rotate to from the north pole.
				//Then, slerp between the two rotations, and generate points across equidistance points on the earth to create the line.
				var north = vec3.fromValues(0, 1, 0);
				var source = object.source;
				var sourceXYZ = vec3.fromValues(xcity[source], zcity[source], -ycity[source]);
				var radius = vec3.length(sourceXYZ);
				var lineSteps = 50;
				var lineX = [];
				var lineY = [];
				var lineZ = [];
				var lineXYZ = vec3.create();

				for (var i = 0; i < object.targets.length; i++) {
					var target = object.targets[i];
					var targetXYZ = vec3.fromValues(xcity[target], zcity[target], -ycity[target]);
					var axis = vec3.cross(vec3.create(), sourceXYZ, targetXYZ);
					vec3.normalize(axis, axis);

					//Get the total angle between the two cities.
					var sourceXYZAxis = vec3.normalize(vec3.create(), sourceXYZ);
					var targetXYZAxis = vec3.normalize(vec3.create(), targetXYZ);
					var dotProduct = vec3.dot(sourceXYZAxis, targetXYZAxis);
					var totalAngle = Math.acos(dotProduct); //theta = arccos(u . v / (||u|| * ||v||); in this case, ||u|| and ||v|| are 1, since u and v are unit vectors.

					var lineQuat = quat.create();
					for (var j = 1; j <= lineSteps; j++) {
						//Calculate the partial rotation to obtain points on the line between the two cities.
						var angle = j / lineSteps * totalAngle;
						quat.setAxisAngle(lineQuat, axis, angle);
						quat.normalize(lineQuat, lineQuat);
						vec3.transformQuat(lineXYZ, sourceXYZ, lineQuat);
						//GL.LINES needs 2 points for each line - at the beginning, just use the sourceXYZ.
						//TODO: Eliminate this if statement.
						if (j === 1) {
							lineX.push(sourceXYZ[0]);
							lineY.push(sourceXYZ[1]);
							lineZ.push(sourceXYZ[2]);
						} else {
							lineX.push(lineX[lineX.length - 1]);
							lineY.push(lineY[lineY.length - 1]);
							lineZ.push(lineZ[lineZ.length - 1]);
						}
						lineX.push(lineXYZ[0]);
						lineY.push(lineXYZ[1]);
						lineZ.push(lineXYZ[2]);
					}
				}
				node.patch('Vertices', [lineX, lineY, lineZ]);
			}
		}
	} //}}}
} //}}}

function randomizeCloudHeight(canvasGroundHeight, object) {
		// -+7000 seems a reasonable range
		var maxHeight = object.height + 7000;
		var minHeigth = object.height - 7000;
		var randomHeight = (Math.random() * (maxHeight - minHeigth)) + minHeigth;

		return canvasGroundHeight + randomHeight;
}

// assumes that originAxisValue is the mid-value between min and max.
function randomizeAxis(originAxisValue, range) {
		return originAxisValue + (Math.random() - 0.5) * (range * 2);
}

function randomizeCloudSize(scale) {
	var maxResize = 1.3;
	var minResize = 0.5;
	var randomizationFactor = Math.random() * (maxResize - minResize) + minResize;
	return scale * randomizationFactor;
}

function randomizeCloudColor() {
	var lighestColor = 1;
	var darkestColor = 0.9;
	var randomColor = Math.random() * (lighestColor - darkestColor) + darkestColor;
	return randomColor;
}
