%HYDROLOGYPISM class definition
%
%   Usage:
%      hydrologypism=hydrologypism();

classdef hydrologypism
	properties (SetAccess=public) 
		drainage_rate = NaN;
	end
	methods
		function self = extrude(self,md) % {{{
		end % }}}
		function self = hydrologypism(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				case 1
					self=structtoobj(self,varargin{1});
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function list = defaultoutputs(self,md) % {{{
			list = {'Watercolumn'};
		end % }}}    

		function self = setdefaultparameters(self) % {{{

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			%Early return
			if ~ismember('HydrologyPismAnalysis',analyses)
				return;
			end

			md = checkfield(md,'fieldname','hydrology.drainage_rate','Inf',1,'NaN',1,'>=',0,'size',[md.mesh.numberofvertices 1]);
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   hydrologypism solution parameters:'));
			fielddisplay(self,'drainage_rate','fixed drainage rate [mm/yr]');
		end % }}}
		function marshall(self,prefix,md,fid) % {{{

			yts=md.constants.yts;

			WriteData(fid,prefix,'name','md.hydrology.model','data',4,'format','Integer');
			WriteData(fid,prefix,'object',self,'class','hydrology','fieldname','drainage_rate','format','DoubleMat','mattype',1,'scale',1./(1000.*yts)); %from mm/yr to m/s
		end % }}}
	end
end

