function plot_transient_movie(md, options, canvas) {//{{{
	/**
	 * PLOT_TRANSIENT_MOVIE - plot a transient result as a movie
	 *
	 * Usage:
	 *	plot_transient_movie(md, options, canvas);
	 *
	 * See also: PLOTMODEL, PLOT_MANAGER
	 */

	// Loop over the time steps
	let data	 	= options.getfieldvalue('transient_field_data');
	let dataType	= {};
	let steps 		= new Array(data.length);

	for (let i = 0, numSteps = steps.length; i < numSteps; ++i) {
		steps[i] = i;
	}

	// Calculate caxis
	if (!options.exist('caxis')) {
		let range 			= [Infinity, -Infinity];
		let	dataResults;

		for (let i in steps) {
			dataResults = processdata(md, data[i], options);
			range[0] = Math.min(range[0], ArrayMin(dataResults[1]));
			range[1] = Math.max(range[1], ArrayMax(dataResults[1]));
		}

		dataType = dataResults[1];
		options.addfielddefault('caxis', range);
	}

	// Create unit node if it does not already exist
	if (!('unit' in canvas.nodes)) {
		let	dataResults = processdata(md, data[0],options);
		let	data2 		= dataResults[0];
		let	dataType 	= dataResults[1];

		// Plot unit
		plot_unit(md,data2,dataType,options,canvas);
	}

	// Setup rendering node
	let node = canvas.nodes.unit;

	node.options 	= options;
	node.alpha 		= options.getfieldvalue('alpha', 1.0);
	node.caxis 		= options.getfieldvalue('caxis');
	node.enabled 	= options.getfieldvalue('nodata', 'off') === 'off';
	node.log 		= options.getfieldvalue('log', false);

	// Process data
	let	dataResults;
	let processedData = [];

	for (let i in steps) {
		dataResults 		= processdata(md, data[i].slice(), options);
		processedData[i] 	= dataResults[0];
	}

	// Display movie
	canvas.unitMovieData		= processedData;
	canvas.animation.frame 		= 0;
	canvas.animation.handler 	= setInterval(function () {
		// Update current animation frame
		let frame 		= canvas.animation.frame;
		let numFrames 	= steps.length;

		if (canvas.animation.play) {
			if (canvas.animation.increment) {
				if (frame >= numFrames - 1) {
					if (canvas.animation.loop) {
						frame = 0;
					} else {
						toggleMoviePlay(canvas);
					}
				} else {
					frame = (frame + 1) % numFrames;
				}
			}
		}

		// If frame has changed, update unit node and data marker display
		if (frame !== canvas.animation.lastFrame) {
			node.updateBuffer('Coords', processedData[frame]);
			canvas.unitData = processedData[frame];

			if (canvas.graph.enabled) {
				vesl.graph.draw(canvas);
			}

			if (!vesl.helpers.isEmptyOrUndefined(canvas.playbackControls.slider)) {
				canvas.playbackControls.slider.val(frame);
			}

			if (!vesl.helpers.isEmptyOrUndefined(canvas.playbackControls.progressText)) {
				canvas.playbackControls.progressText.html(steps[frame].toFixed(0) + ' ' + options.getfieldvalue('movietimeunit', 'yr'));
			}

			if (!vesl.helpers.isEmptyOrUndefined(canvas.nodes.quiver)) {
				plot_quiver(md, options, canvas, false);
			}
		}

		// Save new frame info
		canvas.animation.lastFrame 	= canvas.animation.frame;
		canvas.animation.frame 		= frame;
	}, canvas.animation.interval);

	// Update progress bar with new frame info
	if (!vesl.helpers.isEmptyOrUndefined(canvas.playbackControls.slider)) {
		canvas.playbackControls.slider.val(canvas.animation.frame);
		canvas.playbackControls.slider.setUpperBound(steps.length - 1);
	}

	applyoptions(md, [], options, canvas);
}//}}}
