function plot_transient_movie(md, options, canvas) { //{{{
	//PLOT_TRANSIENT_MOVIE - plot a transient result as a movie
	//
	//   Usage:
	//      plot_transient_movie(md, options, canvas);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER
	
	//loop over the time steps
	var data = options.getfieldvalue('transient_field_data');
	var datatype;
	var steps = new Array(data.length); 
	for (i = 0; i < steps.length; i++) {
		steps[i] = i;
	}
	
	//calculate caxis
	if (!options.exist('caxis')) {
		var range = [Infinity, -Infinity];
		var	dataresults;
		for (var i in steps) {
			dataresults = processdata(md, data[i], options);
			range[0] = Math.min(range[0], ArrayMin(dataresults[1]));
			range[1] = Math.max(range[1], ArrayMax(dataresults[1]));
		}
		datatype = dataresults[1];
		options.addfielddefault('caxis', range);
		
	}
	
	//Create unit node if it does not already exist
	if (!('unit' in canvas.nodes)) {
		var	dataresults = processdata(md, data[0],options);
		var	data2 = dataresults[0]; 
		var	datatype = dataresults[1];
	
		//plot unit
		plot_unit(md,data2,datatype,options,canvas);
	}
	
	//Setup rendering node
	var node = canvas.nodes.unit;
	node.options = options;
	node.alpha = options.getfieldvalue('alpha', 1.0);
	node.caxis = options.getfieldvalue('caxis');
	node.enabled = options.getfieldvalue('nodata', 'off') == 'off';
	node.log = options.getfieldvalue('log', false);
	
	//process data
	var	dataresults;
	var processedData = [];
	for (var i in steps) {
		dataresults = processdata(md, data[i].slice(), options);
		processedData[i] = dataresults[0];
	}
	
	//display movie
	canvas.unitMovieData = processedData;
	canvas.animation.frame = 0;
	canvas.animation.handler = setInterval(function () {
		//Update current animation frame
		var frame = canvas.animation.frame;
		if (canvas.animation.play) {
			if (canvas.animation.increment) {
				if (frame >= steps.length - 1) {
					if (canvas.animation.loop) {
						frame = 0;
					}
					else {
						toggleMoviePlay(canvas);
					}
				}
				else {
					frame = (frame + 1) % steps.length;
				}
			}
		}
		
		//If frame has changed, update unit node and data marker display.
		if (frame !== canvas.animation.lastFrame) {
			node.updateBuffer('Coords', processedData[frame]);
			canvas.unitData = processedData[frame];
			if (canvas.graph.enabled) {
				vesl.graph.draw(canvas);
			}
			if (!vesl.helpers.isEmptyOrUndefined(canvas.playbackSlider)) {
				canvas.playbackSlider.val(frame);
			}
			if (!vesl.helpers.isEmptyOrUndefined(canvas.playbackProgressText)) {
				canvas.playbackProgressText.html(steps[frame].toFixed(0) + " " + options.getfieldvalue("movietimeunit","yr"));
			}
			if (!vesl.helpers.isEmptyOrUndefined(canvas.nodes.quiver)) {
				plot_quiver(md,options,canvas,false);
			}
		}
		
		//Save new frame info.
		canvas.animation.lastFrame = canvas.animation.frame;
		canvas.animation.frame = frame;
	}, canvas.animation.interval);
	
	//Update progress bar with new frame info.
	if (!vesl.helpers.isEmptyOrUndefined(canvas.playbackSlider)) {
		canvas.playbackSlider.val(canvas.animation.frame);
		canvas.playbackSlider.setUpperBound(steps.length - 1);
	}
				
	applyoptions(md, [], options, canvas);
} //}}}
