#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#Some cleanup
rm -rf Dakota
rm -rf src
rm -rf install

#Create src and install directories
mkdir src install

#version of doxygen
version=`echo *.src.tar.gz | sed 's/\.src\.tar\.gz//g' | sed 's/Dakota_//g'`

#Untar 
tar -zxvf  Dakota_$version.src.tar.gz

#Move Dakota to src directory
mv Dakota/* src
rm -rf Dakota

#Configure dakota
cd src
./configure --prefix="$ISSM_DIR/externalpackages/dakota/install" --without-graphics  --with-matlab=$MATLAB_DIR

#Compile dakota
make  -j $NUMCPUS

#Install dakota
make  install
