#include "./GiaIvinsAnalysis.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
void GiaIvinsAnalysis::CreateConstraints(Constraints* constraints,IoModel* iomodel){/*{{{*/
	/*No constraints*/
}/*}}}*/
void GiaIvinsAnalysis::CreateLoads(Loads* loads, IoModel* iomodel){/*{{{*/
	/*No loads*/
}/*}}}*/
void GiaIvinsAnalysis::CreateNodes(Nodes* nodes,IoModel* iomodel){/*{{{*/
	::CreateNodes(nodes,iomodel,GiaIvinsAnalysisEnum,P1Enum);
}/*}}}*/
int  GiaIvinsAnalysis::DofsPerNode(int** doflist,int domaintype,int approximation){/*{{{*/
	return 1;
}/*}}}*/
void GiaIvinsAnalysis::UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,"md.geometry.thickness",ThicknessEnum);
	iomodel->FetchDataToInput(elements,"md.gia.mantle_viscosity",GiaMantleViscosityEnum);
	iomodel->FetchDataToInput(elements,"md.gia.lithosphere_thickness",GiaLithosphereThicknessEnum);
	iomodel->FetchDataToInput(elements,"md.mask.ice_levelset",MaskIceLevelsetEnum);
}/*}}}*/
void GiaIvinsAnalysis::UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/

	parameters->AddObject(iomodel->CopyConstantObject("md.gia.cross_section_shape",GiaCrossSectionShapeEnum));

	/*love numbers: (maybe this should not be in Gia...) */
	iomodel->FetchData(&frequencies,&dummy,&dummy,"md.love.frequencies");
	parameters->AddObject(new DoubleVecParam(LoveFrequenciesEnum,frequencies,nfreq));
	xDelete<IssmDouble>(frequencies);

	parameters->AddObject(iomodel->CopyConstantObject("md.love.nfreq",LoveNfreqEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.sh_nmax",LoveShNmaxEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.sh_nmin",LoveShNminEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.g0",LoveG0Enum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.r0",LoveR0Enum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.mu0",LoveMu0Enum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.allow_layer_deletion",LoveAllowLayerDeletionEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.love_kernels",LoveKernelsEnum));
	parameters->AddObject(iomodel->CopyConstantObject("md.love.forcing_type",LoveForcingTypeEnum));

}/*}}}*/

/*Finite Element Analysis*/
void           GiaIvinsAnalysis::Core(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
ElementVector* GiaIvinsAnalysis::CreateDVector(Element* element){/*{{{*/
	/*Default, return NULL*/
	return NULL;
}/*}}}*/
ElementMatrix* GiaIvinsAnalysis::CreateJacobianMatrix(Element* element){/*{{{*/
_error_("Not implemented");
}/*}}}*/
ElementMatrix* GiaIvinsAnalysis::CreateKMatrix(Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
ElementVector* GiaIvinsAnalysis::CreatePVector(Element* element){/*{{{*/
_error_("not implemented yet");
}/*}}}*/
void           GiaIvinsAnalysis::GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element){/*{{{*/
	   _error_("not implemented yet");
}/*}}}*/
void           GiaIvinsAnalysis::GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index){/*{{{*/
	_error_("Not implemented yet");
}/*}}}*/
void           GiaIvinsAnalysis::InputUpdateFromSolution(IssmDouble* solution,Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
void           GiaIvinsAnalysis::UpdateConstraints(FemModel* femmodel){/*{{{*/
	/*Default, do nothing*/
	return;
}/*}}}*/
