function indices=meshintersect3d(x,y,z,xs,ys,zs,varargin)
%MESHINTERSECT - return indices (into x,y and z) of common values between (x,y,z) and (xs,ys,zs). 
%  i.e: x(index)=xs; y(index)=ys;
%


	%process options: 
	options=pairoptions(varargin{:});

	%retrieve tolerance: 
	tolerance=getfieldvalue(options,'tolerance',10);

	%go through lats,longs and find within tolerance, the index of the corresponding value in lat,long: 
	indices=zeros(length(xs),1);
	
	for i=1:length(xs),
		distance=sqrt((x-xs(i)).^2+(y-ys(i)).^2+(z-zs(i)).^2);
		s=find(distance<tolerance);
		if length(s)>1,
			for j=1:length(s),
				hold on;plot3(x(s(j)),y(s(j)),z(s(j)),'c.','MarkerSize',40)
			end
			distance(s)
			error(sprintf('one or more vertices on the global mesh were duplicated (offset %i)',i));
		elseif isempty(s),
			plot(distance);
			min(distance);
			i
			error('cannot find concurrent vertics!');
		else
			indices(i)=s;
		end
	end
