/*!\file: bmb_core.cpp
 * \brief: core of the bmb (Basal mass balance) solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void bmb_core(FemModel* femmodel){


	/*First, get BMB model from parameters*/
	int  basalforcing_model;
	bool isplume;
	femmodel->parameters->FindParam(&basalforcing_model,BasalforcingsEnum);

	/*In some cases we need to run additional analyses to get the required input data*/
	if(basalforcing_model==BasalforcingsPicoEnum){
		//femmodel->parameters->FindParam(&isplume,BasalforcingsIsplumeEnum);
		if(isplume){

			femmodel->SetCurrentConfiguration(L2ProjectionBaseAnalysisEnum);
			_error_("STOP");
			//femmodel->parameters->SetParam(BaseSlopeXEnum,InputToL2ProjectEnum);
			solutionsequence_linear(femmodel);
			//femmodel->parameters->SetParam(BaseSlopeYEnum,InputToL2ProjectEnum);
			solutionsequence_linear(femmodel);
		}
	}

	/*Call module now*/
	FloatingiceMeltingRatex(femmodel);
}
